/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component;

import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.component.Dsp;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.DspFactory;

public class DspFactoryImpl
implements DspFactory {
    private final ArrayList<String> classes = new ArrayList();

    public void addCodec(String fqn) {
        this.classes.add(fqn);
    }

    public void remove(String fqn) {
        this.classes.remove(fqn);
    }

    public Dsp newProcessor() throws InstantiationException, ClassNotFoundException, IllegalAccessException {
        int numClasses = this.classes.size();
        Codec[] codecs = new Codec[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            String fqn = this.classes.get(i);
            Class<?> codecClass = DspFactoryImpl.class.getClassLoader().loadClass(fqn);
            codecs[i] = (Codec)codecClass.newInstance();
        }
        return new Dsp(codecs);
    }

    public void setCodecs(List<String> list) {
        this.classes.addAll(list);
    }
}

