/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.oob;

import java.util.Iterator;
import org.mobicents.media.server.component.oob.OOBInput;
import org.mobicents.media.server.component.oob.OOBOutput;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.spi.memory.Frame;

public class OOBComponent {
    private ConcurrentMap<OOBInput> inputs = new ConcurrentMap();
    private ConcurrentMap<OOBOutput> outputs = new ConcurrentMap();
    Iterator<OOBInput> activeInputs;
    Iterator<OOBOutput> activeOutputs;
    protected Boolean shouldRead = false;
    protected Boolean shouldWrite = false;
    private Frame frame;
    private int componentId;

    public OOBComponent(int componentId) {
        this.componentId = componentId;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void updateMode(Boolean shouldRead, Boolean shouldWrite) {
        this.shouldRead = shouldRead;
        this.shouldWrite = shouldWrite;
    }

    public void addInput(OOBInput input) {
        this.inputs.put((Object)input.getInputId(), (Object)input);
    }

    public void addOutput(OOBOutput output) {
        this.outputs.put((Object)output.getOutputId(), (Object)output);
    }

    public void remove(OOBInput input) {
        this.inputs.remove((Object)input.getInputId());
    }

    public void remove(OOBOutput output) {
        this.outputs.remove((Object)output.getOutputId());
    }

    public void perform() {
        this.frame = null;
        this.activeInputs = this.inputs.valuesIterator();
        while (this.activeInputs.hasNext()) {
            OOBInput input = this.activeInputs.next();
            this.frame = input.poll();
            if (this.frame == null) continue;
            break;
        }
    }

    public Frame getData() {
        if (!this.shouldRead.booleanValue()) {
            if (this.frame != null) {
                this.frame.recycle();
            }
            return null;
        }
        return this.frame;
    }

    public void offer(Frame frame) {
        if (!this.shouldWrite.booleanValue()) {
            frame.recycle();
            return;
        }
        this.activeOutputs = this.outputs.valuesIterator();
        while (this.activeOutputs.hasNext()) {
            OOBOutput output = this.activeOutputs.next();
            if (!this.activeOutputs.hasNext()) {
                output.offer(frame);
            } else {
                output.offer(frame.clone());
            }
            output.wakeup();
        }
    }
}

