/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.component.audio.Complex;
import org.mobicents.media.server.component.audio.FFT;
import org.mobicents.media.server.component.audio.Resampler;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;

public class SpectraAnalyzer
extends AbstractSink {
    private static final long serialVersionUID = 1646539542777368667L;
    private static final int tolerance = 5;
    private static final AudioFormat LINEAR_AUDIO = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private static final Formats formats = new Formats();
    private double[] buffer = new double[81920];
    private volatile int len;
    private double[] pow;
    private FFT fft = new FFT();
    private Resampler resampler = new Resampler(8000, 8192);
    private AudioOutput output;

    public SpectraAnalyzer(String name, PriorityQueueScheduler scheduler) {
        super(name);
        this.output = new AudioOutput(scheduler, ComponentType.SPECTRA_ANALYZER.getType());
        this.output.join(this);
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    @Override
    public void activate() {
        this.len = 0;
        System.out.println("start, len=" + this.len);
        this.output.start();
    }

    @Override
    public void deactivate() {
        this.output.stop();
    }

    private double[] mod(Complex[] x) {
        double[] res = new double[x.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Math.sqrt(x[i].re() * x[i].re() + x[i].im() * x[i].im());
        }
        return res;
    }

    @Override
    public void onMediaTransfer(Frame frame) throws IOException {
        byte[] data = frame.getData();
        int j = 0;
        for (int i = 0; i < frame.getLength() / 2 && this.len < this.buffer.length; ++i) {
            this.buffer[this.len++] = data[j++] & 0xFF | data[j++] << 8;
        }
    }

    private double[] derivative(double[] spectra) {
        double[] res = new double[spectra.length / 2 - 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = spectra[i + 1] - spectra[i];
        }
        return res;
    }

    private int[] findPeaks(double[] data) {
        ArrayList<Integer> peaks = new ArrayList<Integer>();
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > 1.0E7)) continue;
            peaks.add(i);
        }
        int[] res = new int[peaks.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Integer)peaks.get(i);
        }
        return res;
    }

    private void append(ArrayList<Integer> list, int v) {
        boolean found = false;
        for (int i : list) {
            if (Math.abs(i - v) > 5) continue;
            found = true;
            break;
        }
        if (!found) {
            list.add(v);
        }
    }

    public int[] getSpectra() {
        ArrayList<Integer> frequency = new ArrayList<Integer>();
        System.out.println("len=" + this.len);
        int count = this.len / 8000;
        for (int i = 0; i < count; ++i) {
            double[] data = new double[8000];
            System.arraycopy(this.buffer, 8000 * i, data, 0, 8000);
            double[] s = this.resampler.perform(data, 8000);
            Complex[] signal = new Complex[8192];
            for (int j = 0; j < 8192; ++j) {
                signal[j] = new Complex(s[j], 0.0);
            }
            Complex[] sp = this.fft.fft(signal);
            this.pow = this.mod(sp);
            double[] dif = this.derivative(this.pow);
            int[] freqs = this.findPeaks(dif);
            for (int k = 0; k < freqs.length; ++k) {
                this.append(frequency, freqs[k]);
            }
        }
        int[] res = new int[frequency.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Integer)frequency.get(i);
        }
        return res;
    }

    public void print(String fileName) throws FileNotFoundException, IOException {
        FileOutputStream fout = new FileOutputStream(fileName, false);
        for (int i = 0; i < this.len; ++i) {
            fout.write((i + "  " + this.buffer[i] + "\n").getBytes());
        }
        fout.flush();
        fout.close();
    }

    public Formats getNativeFormats() {
        return formats;
    }

    static {
        formats.add((Format)LINEAR_AUDIO);
    }
}

