/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.oob;

import java.util.Iterator;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.memory.Frame;

public class OOBMixer {
    private PriorityQueueScheduler scheduler;
    private ConcurrentMap<OOBComponent> components = new ConcurrentMap();
    Iterator<OOBComponent> activeComponents;
    private MixTask mixer;
    private volatile boolean started = false;
    public long mixCount = 0L;
    private double gain = 1.0;

    public OOBMixer(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
        this.mixer = new MixTask();
    }

    public void addComponent(OOBComponent component) {
        this.components.put((Object)component.getComponentId(), (Object)component);
    }

    public void release(OOBComponent component) {
        this.components.remove((Object)component.getComponentId());
    }

    public void start() {
        this.mixCount = 0L;
        this.started = true;
        this.scheduler.submit((Task)this.mixer, PriorityQueueScheduler.MIXER_MIX_QUEUE);
    }

    public void stop() {
        this.started = false;
        this.mixer.cancel();
    }

    private class MixTask
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            OOBComponent component;
            int sourceComponent = 0;
            Frame current = null;
            OOBMixer.this.activeComponents = OOBMixer.this.components.valuesIterator();
            while (OOBMixer.this.activeComponents.hasNext()) {
                component = OOBMixer.this.activeComponents.next();
                component.perform();
                current = component.getData();
                if (current == null) continue;
                sourceComponent = component.getComponentId();
                break;
            }
            if (current == null) {
                OOBMixer.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
                ++OOBMixer.this.mixCount;
                return 0L;
            }
            OOBMixer.this.activeComponents = OOBMixer.this.components.valuesIterator();
            while (OOBMixer.this.activeComponents.hasNext()) {
                component = OOBMixer.this.activeComponents.next();
                if (component.getComponentId() == sourceComponent) continue;
                component.offer(current.clone());
            }
            current.recycle();
            OOBMixer.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
            ++OOBMixer.this.mixCount;
            return 0L;
        }
    }
}

