/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.oob;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.memory.Frame;

public class OOBSplitter {
    private final PriorityQueueScheduler scheduler;
    private final ConcurrentMap<OOBComponent> insideComponents;
    private final ConcurrentMap<OOBComponent> outsideComponents;
    private final InsideMixTask insideMixer;
    private final OutsideMixTask outsideMixer;
    private final AtomicBoolean started;
    protected long mixCount = 0L;

    public OOBSplitter(PriorityQueueScheduler scheduler) {
        this.scheduler = scheduler;
        this.insideComponents = new ConcurrentMap();
        this.outsideComponents = new ConcurrentMap();
        this.insideMixer = new InsideMixTask();
        this.outsideMixer = new OutsideMixTask();
        this.started = new AtomicBoolean(false);
    }

    public void addInsideComponent(OOBComponent component) {
        this.insideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    public void addOutsideComponent(OOBComponent component) {
        this.outsideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    public void releaseInsideComponent(OOBComponent component) {
        this.insideComponents.remove((Object)component.getComponentId());
    }

    public void releaseOutsideComponent(OOBComponent component) {
        this.outsideComponents.remove((Object)component.getComponentId());
    }

    public void start() {
        this.mixCount = 0L;
        this.started.set(true);
        this.scheduler.submit((Task)this.insideMixer, PriorityQueueScheduler.MIXER_MIX_QUEUE);
        this.scheduler.submit((Task)this.outsideMixer, PriorityQueueScheduler.MIXER_MIX_QUEUE);
    }

    public void stop() {
        this.started.set(false);
        this.insideMixer.cancel();
        this.outsideMixer.cancel();
    }

    private class OutsideMixTask
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            Frame current = null;
            Iterator outsideRIterator = OOBSplitter.this.outsideComponents.valuesIterator();
            while (outsideRIterator.hasNext()) {
                OOBComponent component = (OOBComponent)outsideRIterator.next();
                component.perform();
                current = component.getData();
                if (current == null) continue;
                break;
            }
            if (current == null) {
                OOBSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
                ++OOBSplitter.this.mixCount;
                return 0L;
            }
            Iterator insideSIterator = OOBSplitter.this.insideComponents.valuesIterator();
            while (insideSIterator.hasNext()) {
                OOBComponent component = (OOBComponent)insideSIterator.next();
                if (!insideSIterator.hasNext()) {
                    component.offer(current);
                    continue;
                }
                component.offer(current.clone());
            }
            OOBSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
            ++OOBSplitter.this.mixCount;
            return 0L;
        }
    }

    private class InsideMixTask
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            Frame current = null;
            Iterator insideRIterator = OOBSplitter.this.insideComponents.valuesIterator();
            while (insideRIterator.hasNext()) {
                OOBComponent component = (OOBComponent)insideRIterator.next();
                component.perform();
                current = component.getData();
                if (current == null) continue;
                break;
            }
            if (current == null) {
                OOBSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
                ++OOBSplitter.this.mixCount;
                return 0L;
            }
            Iterator outsideSIterator = OOBSplitter.this.outsideComponents.valuesIterator();
            while (outsideSIterator.hasNext()) {
                OOBComponent component = (OOBComponent)outsideSIterator.next();
                if (!outsideSIterator.hasNext()) {
                    component.offer(current);
                    continue;
                }
                component.offer(current.clone());
            }
            OOBSplitter.this.scheduler.submit((Task)this, PriorityQueueScheduler.MIXER_MIX_QUEUE);
            ++OOBSplitter.this.mixCount;
            return 0L;
        }
    }
}

