/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import org.apache.log4j.Logger;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.memory.Frame;

public abstract class AbstractSource
extends BaseComponent
implements MediaSource {
    private static final long serialVersionUID = 3157479112733053482L;
    private volatile long txPackets;
    private volatile long txBytes;
    private volatile boolean started;
    private volatile boolean isSynchronized;
    private volatile long timestamp = 0L;
    private long initialOffset;
    private long sn = 1L;
    private PriorityQueueScheduler scheduler;
    private final Worker worker;
    protected long duration = -1L;
    private long initialDelay = 0L;
    protected AbstractSink mediaSink;
    private static final Logger logger = Logger.getLogger(AbstractSource.class);

    public AbstractSource(String name, PriorityQueueScheduler scheduler, int queueNumber) {
        super(name);
        this.scheduler = scheduler;
        this.worker = new Worker(queueNumber);
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getMediaTime() {
        return this.timestamp;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setMediaTime(long timestamp) {
        this.initialOffset = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Worker worker = this.worker;
        synchronized (worker) {
            try {
                if (this.started) {
                    return;
                }
                if (this.scheduler == null) {
                    throw new IllegalArgumentException("Scheduler is not assigned");
                }
                this.txBytes = 0L;
                this.txPackets = 0L;
                this.timestamp = this.initialOffset;
                this.initialOffset = 0L;
                this.sn = 0L;
                this.started = true;
                this.isSynchronized = true;
                if (this.mediaSink != null) {
                    this.mediaSink.start();
                }
                this.worker.reinit();
                this.scheduler.submit((Task)this.worker, Integer.valueOf(this.worker.getQueueNumber()));
                this.started();
            }
            catch (Exception e) {
                this.started = false;
                this.failed(e);
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Worker worker = this.worker;
        synchronized (worker) {
            if (!this.started) {
                return;
            }
            if (!this.isSynchronized) {
                this.isSynchronized = true;
                this.scheduler.submit((Task)this.worker, Integer.valueOf(this.worker.getQueueNumber()));
            }
        }
    }

    public void stop() {
        if (this.started) {
            this.stopped();
        }
        this.started = false;
        if (this.worker != null) {
            this.worker.cancel();
        }
        if (this.mediaSink != null) {
            this.mediaSink.stop();
        }
        this.timestamp = 0L;
    }

    public void activate() {
        this.start();
    }

    public void deactivate() {
        this.stop();
    }

    protected void connect(AbstractSink sink) {
        this.mediaSink = sink;
        if (this.started) {
            this.mediaSink.start();
        }
    }

    protected void disconnect() {
        if (this.mediaSink != null) {
            this.mediaSink.stop();
            this.mediaSink = null;
        }
    }

    public boolean isConnected() {
        return this.mediaSink != null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public abstract Frame evolve(long var1);

    protected void started() {
    }

    protected void failed(Exception e) {
    }

    protected void completed() {
        this.started = false;
    }

    protected void stopped() {
    }

    public long getPacketsTransmitted() {
        return this.txPackets;
    }

    public long getBytesTransmitted() {
        return this.txBytes;
    }

    public void reset() {
        this.txPackets = 0L;
        this.txBytes = 0L;
    }

    public String report() {
        return "";
    }

    private class Worker
    extends Task {
        private int queueNumber;
        private long initialTime;
        int readCount = 0;
        int length;
        long overallDelay = 0L;
        Frame frame;
        long frameDuration;
        Boolean isEOM;

        public Worker(int queueNumber) {
            this.queueNumber = queueNumber;
            this.initialTime = AbstractSource.this.scheduler.getClock().getTime();
        }

        public void reinit() {
            this.initialTime = AbstractSource.this.scheduler.getClock().getTime();
        }

        public int getQueueNumber() {
            return this.queueNumber;
        }

        public long perform() {
            if (AbstractSource.this.initialDelay + this.initialTime > AbstractSource.this.scheduler.getClock().getTime()) {
                AbstractSource.this.scheduler.submit((Task)this, Integer.valueOf(this.queueNumber));
                return 0L;
            }
            this.readCount = 0;
            this.overallDelay = 0L;
            while (this.overallDelay < 20000000L) {
                ++this.readCount;
                this.frame = AbstractSource.this.evolve(AbstractSource.this.timestamp);
                if (this.frame == null) {
                    if (this.readCount == 1) {
                        AbstractSource.this.isSynchronized = false;
                        return 0L;
                    }
                    AbstractSource.this.scheduler.submit((Task)this, Integer.valueOf(this.queueNumber));
                    return 0L;
                }
                this.frame.setTimestamp(AbstractSource.this.timestamp);
                this.frame.setSequenceNumber(AbstractSource.this.sn);
                AbstractSource.this.timestamp += this.frame.getDuration();
                this.overallDelay += this.frame.getDuration();
                AbstractSource.this.sn = AbstractSource.this.sn == Long.MAX_VALUE ? 0L : AbstractSource.this.sn + 1L;
                if (AbstractSource.this.duration > 0L && AbstractSource.this.timestamp >= AbstractSource.this.duration) {
                    this.frame.setEOM(true);
                }
                this.frameDuration = this.frame.getDuration();
                this.isEOM = this.frame.isEOM();
                this.length = this.frame.getLength();
                if (AbstractSource.this.mediaSink != null) {
                    AbstractSource.this.mediaSink.perform(this.frame);
                }
                AbstractSource.this.txPackets++;
                AbstractSource.this.txBytes += this.length;
                if (this.isEOM.booleanValue()) {
                    AbstractSource.this.started = false;
                    AbstractSource.this.completed();
                    return -1L;
                }
                if (this.frameDuration > 0L) continue;
                AbstractSource.this.isSynchronized = false;
                return 0L;
            }
            AbstractSource.this.scheduler.submit((Task)this, Integer.valueOf(this.queueNumber));
            return 0L;
        }

        public String toString() {
            return AbstractSource.this.getName();
        }
    }
}

