/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.MediaSink;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.spi.memory.Frame;

public abstract class AbstractSink
extends BaseComponent
implements MediaSink {
    private static final long serialVersionUID = -2119158462149998609L;
    private volatile boolean started = false;
    private volatile long rxPackets;
    private volatile long rxBytes;
    private static final Logger logger = Logger.getLogger(AbstractSink.class);

    public AbstractSink(String name) {
        super(name);
    }

    public boolean isStarted() {
        return this.started;
    }

    public abstract void onMediaTransfer(Frame var1) throws IOException;

    protected void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.rxBytes = 0L;
        this.rxPackets = 0L;
        this.started();
    }

    protected void stop() {
        this.started = false;
        this.stopped();
    }

    public abstract void activate();

    public abstract void deactivate();

    protected void failed(Exception e) {
    }

    public long getPacketsReceived() {
        return this.rxPackets;
    }

    public long getBytesReceived() {
        return this.rxBytes;
    }

    public void reset() {
        this.rxPackets = 0L;
        this.rxBytes = 0L;
    }

    protected void started() {
    }

    protected void stopped() {
    }

    public String report() {
        return "";
    }

    public void perform(Frame frame) {
        if (!this.started) {
            return;
        }
        if (frame == null) {
            return;
        }
        ++this.rxPackets;
        this.rxBytes += (long)frame.getLength();
        try {
            this.onMediaTransfer(frame);
        }
        catch (IOException e) {
            logger.error((Object)e);
            this.started = false;
            this.failed(e);
        }
    }
}

