/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

public class Resampler {
    private int f;
    private int F;

    public Resampler(int f, int F) {
        this.f = f;
        this.F = F;
    }

    public double[] perform(double[] buffer, int len) {
        int size = (int)((double)this.F / (double)this.f * (double)len);
        double[] signal = new double[size];
        double dx = 1.0 / (double)this.f;
        double dX = 1.0 / (double)this.F;
        signal[0] = buffer[0];
        double k = 0.0;
        for (int i = 1; i < size - 1; ++i) {
            double X = (double)i * dX;
            int p = (int)(X / dx);
            int q = p + 1;
            k = (buffer[q] - buffer[p]) / dx;
            double x = (double)p * dx;
            signal[i] = buffer[p] + (X - x) * k;
        }
        signal[size - 1] = buffer[len - 1] + ((double)(size - 1) * dX - (double)(len - 1) * dx) * k;
        return signal;
    }
}

