/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.media.server.mgcp.controller.CallManager;
import org.mobicents.media.server.mgcp.controller.MgcpConnection;
import org.mobicents.media.server.utils.Text;

public class MgcpCall {
    private CallManager callManager;
    protected Text id = new Text(new byte[30], 0, 30);
    protected ConcurrentHashMap<Text, MgcpConnection> connections = new ConcurrentHashMap(20);

    protected MgcpCall(CallManager callManager, Text id) {
        id.duplicate(this.id);
        this.id.trim();
        this.callManager = callManager;
    }

    public MgcpConnection getMgcpConnection(Text id) {
        Enumeration<Text> e = this.connections.keys();
        while (e.hasMoreElements()) {
            Text currText = e.nextElement();
            if (!currText.equals((Object)id)) continue;
            return this.connections.get(currText);
        }
        return null;
    }

    public void exclude(MgcpConnection activity) {
        this.connections.remove(activity.id);
        if (this.connections.isEmpty()) {
            this.callManager.terminate(this);
        }
    }

    public int size() {
        return this.connections.size();
    }

    public void deleteConnections() {
        Enumeration<Text> e = this.connections.keys();
        while (e.hasMoreElements()) {
            MgcpConnection currConnection = this.connections.remove(e.nextElement());
            currConnection.mgcpEndpoint.deleteConnection(currConnection.getID());
        }
        if (this.connections.isEmpty()) {
            this.callManager.terminate(this);
        }
    }

    public String toString() {
        return "call[" + this.id + "]";
    }
}

