/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller;

import java.io.IOException;
import java.net.SocketAddress;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.controller.MgcpCall;
import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionFailureListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ModeNotSupportedException;
import org.mobicents.media.server.utils.Text;

public class MgcpConnection
implements ConnectionFailureListener {
    public static final Text REASON_CODE = new Text("902 Loss of lower layer connectivity");
    protected Text id;
    protected MgcpCall call;
    protected MgcpEndpoint mgcpEndpoint;
    protected Connection connection;
    private SocketAddress callAgent;
    private Text descriptor = new Text();

    public MgcpConnection() {
        this.id = new Text(Long.toHexString(System.nanoTime()));
    }

    public Text getID() {
        return this.id;
    }

    protected void setCall(MgcpCall call) {
        this.call = call;
        call.connections.put(this.id, this);
    }

    public void setCallAgent(SocketAddress callAgent) {
        this.callAgent = callAgent;
    }

    public void wrap(MgcpEndpoint mgcpEndpoint, MgcpCall call, Connection connection) {
        this.mgcpEndpoint = mgcpEndpoint;
        this.call = call;
        this.connection = connection;
        this.connection.setConnectionFailureListener((ConnectionFailureListener)this);
        call.connections.put(this.id, this);
    }

    public void setMode(Text mode) throws ModeNotSupportedException {
        this.connection.setMode(ConnectionMode.valueOf((Text)mode));
    }

    public void setMode(ConnectionMode mode) throws ModeNotSupportedException {
        this.connection.setMode(mode);
    }

    public void setGain(int gain) {
        this.connection.setGain((double)gain);
    }

    public void setDtmfClamp(boolean dtmfClamp) {
        this.connection.setDtmfClamp(dtmfClamp);
    }

    public Text getDescriptor() {
        if (this.connection.getDescriptor() != null) {
            this.descriptor.strain(this.connection.getDescriptor().getBytes(), 0, this.connection.getDescriptor().length());
            return this.descriptor;
        }
        return null;
    }

    public void setOtherParty(Text sdp) throws IOException {
        this.connection.setOtherParty(sdp);
    }

    public void setOtherParty(MgcpConnection other) throws IOException {
        this.connection.setOtherParty(other.connection);
    }

    public void release() {
        this.call.exclude(this);
    }

    public int getPacketsTransmitted() {
        return (int)this.connection.getPacketsTransmitted(MediaType.AUDIO);
    }

    public int getPacketsReceived() {
        return (int)this.connection.getPacketsReceived(MediaType.AUDIO);
    }

    public void onFailure() {
        this.mgcpEndpoint.offer(this);
        MgcpEvent evt = this.mgcpEndpoint.mgcpProvider.createEvent(1, this.callAgent);
        MgcpRequest msg = (MgcpRequest)evt.getMessage();
        msg.setCommand(new Text("DLCX"));
        msg.setEndpoint(this.mgcpEndpoint.fullName);
        msg.setParameter(Parameter.CONNECTION_ID, this.id);
        msg.setTxID(MgcpEndpoint.txID.incrementAndGet());
        msg.setParameter(Parameter.REASON_CODE, REASON_CODE);
        this.mgcpEndpoint.send(evt, this.callAgent);
    }
}

