/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller.naming;

import java.util.ArrayList;
import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.controller.MgcpEndpointStateListener;
import org.mobicents.media.server.scheduler.ConcurrentLinkedList;
import org.mobicents.media.server.utils.Text;

public class EndpointQueue
implements MgcpEndpointStateListener {
    private static final int SIZE = 100;
    private static final Text ANY = new Text("$");
    private static final Text ALL = new Text("*");
    private ArrayList<Holder> completeList = new ArrayList(100);
    private ConcurrentLinkedList<MgcpEndpoint> queue = new ConcurrentLinkedList();
    private int k;

    public void add(MgcpEndpoint endpoint) {
        Holder holder = new Holder(endpoint);
        endpoint.setMgcpEndpointStateListener(this);
        this.completeList.add(holder);
        this.queue.offer((Object)endpoint);
    }

    public void remove(MgcpEndpoint endpoint) {
        for (int i = 0; i < this.completeList.size(); ++i) {
            if (this.completeList.get((int)i).endpoint != endpoint) continue;
            this.completeList.remove(i);
            break;
        }
        this.queue.remove((Object)endpoint);
    }

    public int find(Text name, MgcpEndpoint[] endpoints) {
        if (name.equals((Object)ALL)) {
            this.k = 0;
            for (int i = 0; i < this.completeList.size(); ++i) {
                endpoints[this.k++] = this.completeList.get((int)i).endpoint;
            }
            return this.completeList.size();
        }
        if (name.equals((Object)ANY)) {
            MgcpEndpoint endp = (MgcpEndpoint)this.queue.poll();
            if (endp != null) {
                endp.lock();
                endpoints[0] = endp;
                return 1;
            }
            return 0;
        }
        int value = name.toInteger();
        if (value > 0 && value < this.completeList.size()) {
            endpoints[0] = this.completeList.get((int)(value - 1)).endpoint;
            return 1;
        }
        for (Holder h : this.completeList) {
            if (!h.name.equals((Object)name)) continue;
            endpoints[0] = h.endpoint;
            return 1;
        }
        return 0;
    }

    public void onFreed(MgcpEndpoint endpoint) {
        this.queue.offer((Object)endpoint);
    }

    private class Holder {
        protected MgcpEndpoint endpoint;
        protected Text name;

        protected Holder(MgcpEndpoint endpoint) {
            this.endpoint = endpoint;
            String[] tokens = endpoint.getName().split("/");
            this.name = new Text(tokens[tokens.length - 1]);
        }
    }
}

