/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller.naming;

import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.controller.naming.EndpointQueue;
import org.mobicents.media.server.mgcp.controller.naming.NamingNode;
import org.mobicents.media.server.mgcp.controller.naming.UnknownEndpointException;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.scheduler.ConcurrentLinkedList;
import org.mobicents.media.server.scheduler.DefaultClock;
import org.mobicents.media.server.utils.Text;

public class NamingTree {
    private NamingNode<EndpointQueue> root = new NamingNode(new Text("root"), null);
    private ConcurrentLinkedList<Text[]> patterns = new ConcurrentLinkedList();
    private static UnknownEndpointException UNKNOWN_ENDPOINT_EXCEPTION;
    public static Clock clock;

    public NamingTree() {
        for (int j = 0; j < 50; ++j) {
            Text[] pattern = new Text[10];
            for (int i = 0; i < pattern.length; ++i) {
                pattern[i] = new Text();
            }
            this.patterns.offer((Object)pattern);
        }
    }

    public synchronized void register(MgcpEndpoint endpoint) {
        String[] tokens = endpoint.getName().split("/");
        Text[] path = new Text[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            path[i] = new Text(tokens[i]);
        }
        NamingNode<EndpointQueue> currentNode = this.root;
        for (int i = 0; i < path.length - 1; ++i) {
            NamingNode<EndpointQueue> foundNode = currentNode.find(new Text[]{path[i]}, 1);
            NamingNode<EndpointQueue> namingNode = currentNode = foundNode != null ? foundNode : currentNode.createChild(path[i]);
            if (currentNode.poll() != null) continue;
            currentNode.attach(new EndpointQueue());
        }
        currentNode.poll().add(endpoint);
    }

    public void unregister(MgcpEndpoint endpoint) {
    }

    public int find(Text name, MgcpEndpoint[] endpoints) throws UnknownEndpointException {
        Text[] pattern = (Text[])this.patterns.poll();
        if (pattern == null) {
            pattern = new Text[10];
            for (int i = 0; i < pattern.length; ++i) {
                pattern[i] = new Text();
            }
        }
        NamingNode node = null;
        int n = name.divide('/', pattern);
        node = this.root.find(pattern, n - 1);
        if (node == null) {
            throw new UnknownEndpointException();
        }
        int result = ((EndpointQueue)node.poll()).find(pattern[n - 1], endpoints);
        this.patterns.offer((Object)pattern);
        return result;
    }

    static {
        clock = new DefaultClock();
    }
}

