/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.ann;

import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.utils.Text;

public class Play
extends Signal
implements PlayerListener {
    private Text oc = new Text("oc");
    private Text of = new Text("of");
    private Player player;
    private String uri;
    private static final Logger logger = Logger.getLogger(Play.class);

    public Play(String name) {
        super(name);
    }

    public void execute() {
        logger.info((Object)"Executing...");
        this.player = this.getPlayer();
        try {
            this.player.addListener((PlayerListener)this);
            this.uri = this.getTrigger().getParams().toString();
            this.player.setURL(this.uri);
            logger.info((Object)("Assigned url " + this.player));
        }
        catch (TooManyListenersException e) {
            this.sendEvent(this.of);
            this.complete();
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
            return;
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.sendEvent(this.of);
            this.complete();
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.sendEvent(this.of);
            this.complete();
            return;
        }
        this.player.start();
    }

    public boolean doAccept(Text event) {
        if (event.equals((Object)this.oc)) {
            return true;
        }
        return event.equals((Object)this.of);
    }

    public void cancel() {
        if (this.player != null) {
            this.player.removeListener((PlayerListener)this);
            this.player.stop();
        }
    }

    private Player getPlayer() {
        if (this.getTrigger().getConnectionID() == null) {
            Endpoint endpoint = this.getEndpoint();
            return (Player)this.getEndpoint().getResource(MediaType.AUDIO, Player.class);
        }
        String connectionID = this.getTrigger().getConnectionID().toString();
        Connection connection = this.getConnection(connectionID);
        if (connection == null) {
            return null;
        }
        return null;
    }

    public void reset() {
        super.reset();
        if (this.player != null) {
            this.player.removeListener((PlayerListener)this);
            this.player.stop();
        }
    }

    public void process(PlayerEvent event) {
        switch (event.getID()) {
            case 2: {
                this.player.removeListener((PlayerListener)this);
                this.sendEvent(this.oc);
                this.complete();
                break;
            }
            case 3: {
                this.player.removeListener((PlayerListener)this);
                this.sendEvent(this.of);
                this.complete();
            }
        }
    }
}

