/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.au;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.pkg.au.BufferListener;
import org.mobicents.media.server.scheduler.ConcurrentLinkedList;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorListener;
import org.mobicents.media.server.spi.dtmf.DtmfEvent;
import org.mobicents.media.server.utils.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBuffer
implements DtmfDetectorListener {
    private String sequence = "";
    private Collection<Text> patterns;
    private int count;
    private BufferListener listener;
    private volatile boolean isActive = false;
    private ConcurrentLinkedList<DtmfEvent> queue = new ConcurrentLinkedList();
    private Logger logger = Logger.getLogger(EventBuffer.class);

    public void activate() {
        this.isActive = true;
    }

    public void passivate() {
        this.isActive = false;
    }

    public int length() {
        return this.sequence.length();
    }

    public String getSequence() {
        return this.sequence;
    }

    public void flush() {
        if (!this.isActive) {
            return;
        }
        while (!this.queue.isEmpty()) {
            this.process((DtmfEvent)this.queue.poll());
        }
    }

    public void reset() {
        this.sequence = "";
        this.count = -1;
        this.queue.clear();
    }

    public void clear() {
        this.sequence = "";
        this.queue.clear();
    }

    public void setPatterns(Collection<Text> patterns) {
        this.patterns = patterns;
        this.sequence = "";
    }

    public void setCount(int count) {
        this.count = count;
        this.sequence = "";
    }

    public void setListener(BufferListener listener) {
        this.listener = listener;
    }

    public void process(DtmfEvent event) {
        this.logger.info((Object)("Receive " + event.getTone() + " tone"));
        if (!this.listener.tone(event.getTone())) {
            return;
        }
        if (this.isActive) {
            this.process(event.getTone());
        } else {
            this.queue.offer((Object)event);
        }
    }

    private void process(String tone) {
        this.sequence = this.sequence + tone;
        boolean sequenceFound = false;
        if (this.patterns != null && this.sequence.length() > 0) {
            int i = 0;
            for (Text pattern : this.patterns) {
                if (this.sequence.matches(pattern.toString()) || tone.matches(pattern.toString())) {
                    this.listener.patternMatches(i, this.sequence);
                    this.sequence = "";
                    sequenceFound = true;
                    break;
                }
                ++i;
            }
        }
        if (!sequenceFound && this.count > 0 && this.sequence.length() == this.count) {
            this.listener.countMatches(this.sequence);
            this.sequence = "";
        }
    }
}

