/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.au;

import java.net.MalformedURLException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.au.Options;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.utils.Text;

public class Play
extends Signal
implements PlayerListener {
    private Event oc = new Event(new Text("oc"));
    private Event of = new Event(new Text("of"));
    private Player player;
    private volatile Options options;
    private int repeatCount;
    private int segCount;
    private long delay;
    private String uri;
    private Iterator<Text> segments;
    private static final Logger logger = Logger.getLogger(Play.class);

    public Play(String name) {
        super(name);
        this.oc.add(new NotifyImmediately("N"));
        this.of.add(new NotifyImmediately("N"));
    }

    public void execute() {
        this.player = this.getPlayer();
        if (this.player == null) {
            this.of.fire(this, new Text("Endpoint has no player"));
            this.complete();
            return;
        }
        try {
            this.player.addListener((PlayerListener)this);
        }
        catch (TooManyListenersException e) {
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
        this.options = new Options(this.getTrigger().getParams());
        this.delay = 0L;
        this.segments = this.options.getSegments().iterator();
        this.repeatCount = this.options.getRepeatCount();
        this.uri = this.segments.next().toString();
        this.startAnnouncementPhase();
    }

    private void startAnnouncementPhase() {
        logger.info((Object)String.format("(%s) Start announcement (segment=%d)", this.getEndpoint().getLocalName(), this.segCount));
        try {
            this.player.setURL(this.uri);
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text("rc=301"));
            this.complete();
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text("rc=312"));
            this.complete();
            return;
        }
        if (this.options.getDuration() != -1) {
            this.player.setDuration((long)this.options.getDuration() * 1000000L);
        }
        if (this.options.getOffset() > 0) {
            this.player.setMediaTime((long)this.options.getOffset() * 1000000L);
        }
        this.player.setInitialDelay(this.delay * 1000000L);
        this.player.start();
    }

    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    public void cancel() {
        this.terminate();
    }

    private Player getPlayer() {
        if (this.getTrigger().getConnectionID() == null) {
            Endpoint endpoint = this.getEndpoint();
            return (Player)this.getEndpoint().getResource(MediaType.AUDIO, Player.class);
        }
        String connectionID = this.getTrigger().getConnectionID().toString();
        Connection connection = this.getConnection(connectionID);
        if (connection == null) {
            return null;
        }
        return null;
    }

    public void reset() {
        super.reset();
        this.terminate();
        this.oc.reset();
        this.of.reset();
    }

    private void terminate() {
        if (this.player != null) {
            this.player.removeListener((PlayerListener)this);
            this.player.stop();
        }
    }

    private void repeat(long delay) {
        this.delay = delay;
        this.startAnnouncementPhase();
    }

    private void next(long delay) {
        this.uri = this.segments.next().toString();
        ++this.segCount;
        this.delay = delay;
        this.startAnnouncementPhase();
    }

    public void process(PlayerEvent event) {
        switch (event.getID()) {
            case 2: {
                logger.info((Object)String.format("(%s) Announcement (segment=%d) has completed", this.getEndpoint().getLocalName(), this.segCount));
                --this.repeatCount;
                if (this.repeatCount > 0) {
                    this.repeat(this.options.getInterval());
                    return;
                }
                if (this.segments.hasNext()) {
                    this.next(this.options.getInterval());
                    return;
                }
                this.terminate();
                this.oc.fire(this, new Text("rc=100"));
                this.complete();
                break;
            }
            case 3: {
                this.terminate();
                this.oc.fire(this, null);
                this.complete();
            }
        }
    }
}

