/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.au;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.au.BufferListener;
import org.mobicents.media.server.mgcp.pkg.au.EventBuffer;
import org.mobicents.media.server.mgcp.pkg.au.Options;
import org.mobicents.media.server.mgcp.pkg.au.PlayerMode;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.dtmf.DtmfDetector;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorListener;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.spi.recorder.Recorder;
import org.mobicents.media.server.spi.recorder.RecorderEvent;
import org.mobicents.media.server.spi.recorder.RecorderListener;
import org.mobicents.media.server.utils.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayRecord
extends Signal {
    private Event oc = new Event(new Text("oc"));
    private Event of = new Event(new Text("of"));
    private volatile boolean isActive;
    private Player player;
    private Recorder recorder;
    private DtmfDetector dtmfDetector;
    private Options options;
    private EventBuffer buffer = new EventBuffer();
    private RecordingHandler recordingHandler;
    private DtmfHandler dtmfHandler;
    private PromptHandler promptHandler;
    private volatile boolean isPromptActive;
    private Text[] prompt = new Text[10];
    private Text[] deletePersistentAudio = new Text[100];
    private int promptLength = 0;
    private int promptIndex = 0;
    private int deletePersistentAudioLength = 0;
    private int numberOfAttempts = 1;
    private boolean isCompleted;
    private static final Logger logger = Logger.getLogger(PlayRecord.class);
    private int segCount = 0;
    private PlayerMode playerMode = PlayerMode.PROMPT;
    private Text eventContent;

    public PlayRecord(String name) {
        super(name);
        this.oc.add(new NotifyImmediately("N"));
        this.of.add(new NotifyImmediately("N"));
        this.recordingHandler = new RecordingHandler(this);
        this.dtmfHandler = new DtmfHandler(this);
        this.promptHandler = new PromptHandler(this);
    }

    @Override
    public void execute() {
        if (this.getEndpoint().getActiveConnectionsCount() == 0) {
            this.oc.fire(this, new Text("rc=327"));
            this.complete();
            return;
        }
        this.promptLength = 0;
        this.promptIndex = 0;
        this.segCount = 0;
        this.isCompleted = false;
        this.isActive = true;
        this.options = new Options(this.getTrigger().getParams());
        if (this.options.hasDeletePresistentAudio()) {
            File f;
            int i;
            this.deletePersistentAudioLength = this.options.getDeletePersistentAudio().size();
            this.deletePersistentAudio = this.options.getDeletePersistentAudio().toArray(this.deletePersistentAudio);
            for (i = 0; i < this.deletePersistentAudioLength; ++i) {
                try {
                    f = new File(this.deletePersistentAudio[i].toString());
                    if (f.exists()) continue;
                    this.oc.fire(this, new Text("rc=320 ri=" + this.deletePersistentAudio[i].toString()));
                    this.isCompleted = true;
                    this.complete();
                    return;
                }
                catch (Exception ex) {
                    logger.error((Object)"OPERATION FAILURE", (Throwable)ex);
                }
            }
            for (i = 0; i < this.deletePersistentAudioLength; ++i) {
                f = new File(this.deletePersistentAudio[i].toString());
                f.delete();
            }
            this.oc.fire(this, new Text("rc=100"));
            this.isCompleted = true;
            this.complete();
            return;
        }
        this.playerMode = PlayerMode.PROMPT;
        this.numberOfAttempts = this.options.getNumberOfAttempts() > 1 ? this.options.getNumberOfAttempts() : 1;
        logger.info((Object)String.format("(%s) Prepare digit collect phase", this.getEndpoint().getLocalName()));
        this.prepareCollectPhase(this.options);
        if (this.options.hasPrompt()) {
            logger.info((Object)String.format("(%s) Start prompt phase", this.getEndpoint().getLocalName()));
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
            return;
        }
        logger.info((Object)String.format("(%s) Start collect phase", this.getEndpoint().getLocalName()));
        this.flushBuffer();
        this.startCollectPhase();
        logger.info((Object)String.format("(%s) Start record phase", this.getEndpoint().getLocalName()));
        this.startRecordPhase(this.options);
    }

    @Override
    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    @Override
    public void cancel() {
        this.isActive = false;
        this.terminate();
    }

    private void startPromptPhase(Collection<Text> promptList) {
        this.player = this.getPlayer();
        try {
            this.player.addListener((PlayerListener)this.promptHandler);
            this.promptLength = promptList.size();
            this.prompt = promptList.toArray(this.prompt);
            this.player.setURL(this.prompt[0].toString());
            this.player.start();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, new Text("Too many listeners"));
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void terminatePrompt() {
        if (this.promptLength > 0) {
            this.promptIndex = this.promptLength - 1;
        }
        if (this.player != null) {
            this.player.stop();
            this.player.removeListener((PlayerListener)this.promptHandler);
        }
    }

    private void startRecordPhase(Options options) {
        this.recorder = this.getRecorder();
        this.recorder.setMaxRecordTime(options.getRecordDuration());
        this.recorder.setPostSpeechTimer(options.getPostSpeechTimer());
        if (options.getPreSpeechTimer() > 0L) {
            this.recorder.setPreSpeechTimer(options.getPreSpeechTimer());
        } else {
            this.recorder.setPreSpeechTimer(options.getPostSpeechTimer());
        }
        try {
            this.recorder.addListener((RecorderListener)this.recordingHandler);
            this.recorder.setRecordFile(options.getRecordID().toString(), !options.isOverride());
            this.recorder.start();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, new Text("Too many listeners"));
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
        catch (IOException e) {
            logger.info((Object)"Received Recording URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
        }
    }

    private void terminateRecordPhase() {
        if (this.recorder != null) {
            this.recorder.stop();
            this.recorder.removeListener((RecorderListener)this.recordingHandler);
        }
    }

    private void prepareCollectPhase(Options options) {
        this.dtmfDetector = this.getDetector();
        if (options.isClearDigits()) {
            this.dtmfDetector.clearDigits();
        }
        this.buffer.reset();
        this.buffer.setListener(this.dtmfHandler);
        this.buffer.setPatterns(options.getDigitPattern());
        this.buffer.setCount(options.getDigitsNumber());
    }

    private void terminateCollectPhase() {
        if (this.dtmfDetector != null) {
            this.dtmfDetector.removeListener((DtmfDetectorListener)this.buffer);
            this.buffer.passivate();
            this.buffer.clear();
        }
    }

    private void flushBuffer() {
        try {
            this.dtmfDetector.addListener((DtmfDetectorListener)this.buffer);
            this.dtmfDetector.flushBuffer();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, new Text("Too many listeners for DTMF detector"));
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
    }

    private void startCollectPhase() {
        this.buffer.activate();
        this.buffer.flush();
    }

    private void terminate() {
        this.terminatePrompt();
        this.terminateRecordPhase();
        this.terminateCollectPhase();
    }

    private void decreaseNa() {
        --this.numberOfAttempts;
        if (this.options.hasReprompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getReprompt());
        } else if (this.options.hasPrompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
        } else {
            this.startCollectPhase();
        }
    }

    private Player getPlayer() {
        if (this.getTrigger().getConnectionID() == null) {
            Endpoint endpoint = this.getEndpoint();
            return (Player)this.getEndpoint().getResource(MediaType.AUDIO, Player.class);
        }
        String connectionID = this.getTrigger().getConnectionID().toString();
        Connection connection = this.getConnection(connectionID);
        if (connection == null) {
            return null;
        }
        return null;
    }

    private Recorder getRecorder() {
        if (this.getTrigger().getConnectionID() == null) {
            Endpoint endpoint = this.getEndpoint();
            return (Recorder)this.getEndpoint().getResource(MediaType.AUDIO, Recorder.class);
        }
        String connectionID = this.getTrigger().getConnectionID().toString();
        Connection connection = this.getConnection(connectionID);
        if (connection == null) {
            return null;
        }
        return null;
    }

    private DtmfDetector getDetector() {
        if (this.getTrigger().getConnectionID() == null) {
            Endpoint endpoint = this.getEndpoint();
            return (DtmfDetector)this.getEndpoint().getResource(MediaType.AUDIO, DtmfDetector.class);
        }
        String connectionID = this.getTrigger().getConnectionID().toString();
        Connection connection = this.getConnection(connectionID);
        if (connection == null) {
            return null;
        }
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        this.terminate();
        this.oc.reset();
        this.of.reset();
    }

    private void next(long delay) {
        ++this.segCount;
        ++this.promptIndex;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player next with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void prev(long delay) {
        ++this.segCount;
        --this.promptIndex;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player prev with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void curr(long delay) {
        ++this.segCount;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player curr with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void first(long delay) {
        ++this.segCount;
        this.promptIndex = 0;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player first with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void last(long delay) {
        ++this.segCount;
        this.promptIndex = this.promptLength - 1;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player last with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private class DtmfHandler
    implements BufferListener {
        private PlayRecord signal;

        public DtmfHandler(PlayRecord signal) {
            this.signal = signal;
        }

        public void patternMatches(int index, String s) {
            if (PlayRecord.this.options.hasSuccessAnnouncement()) {
                PlayRecord.this.eventContent = new Text("rc=100 dc=" + s + " pi=" + index);
                PlayRecord.this.playerMode = PlayerMode.SUCCESS;
                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getSuccessAnnouncement());
            } else {
                PlayRecord.this.oc.fire(this.signal, new Text("rc=100 dc=" + s + " pi=" + index));
                PlayRecord.this.reset();
                PlayRecord.this.isCompleted = true;
                PlayRecord.this.complete();
            }
        }

        public void countMatches(String s) {
            if (PlayRecord.this.options.hasSuccessAnnouncement()) {
                PlayRecord.this.eventContent = new Text("rc=100 dc=" + s);
                PlayRecord.this.playerMode = PlayerMode.SUCCESS;
                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getSuccessAnnouncement());
            } else {
                PlayRecord.this.oc.fire(this.signal, new Text("rc=100 dc=" + s));
                PlayRecord.this.reset();
                PlayRecord.this.isCompleted = true;
                PlayRecord.this.complete();
            }
        }

        public boolean tone(String s) {
            logger.info((Object)String.format("(%s) Tone '%s' has been detected", PlayRecord.this.getEndpoint().getLocalName(), s));
            if (PlayRecord.this.isPromptActive) {
                if (PlayRecord.this.options.prevKeyValid() && PlayRecord.this.options.getPrevKey() == s.charAt(0)) {
                    PlayRecord.this.prev(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.firstKeyValid() && PlayRecord.this.options.getFirstKey() == s.charAt(0)) {
                    PlayRecord.this.first(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.currKeyValid() && PlayRecord.this.options.getCurrKey() == s.charAt(0)) {
                    PlayRecord.this.curr(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.nextKeyValid() && PlayRecord.this.options.getNextKey() == s.charAt(0)) {
                    PlayRecord.this.first(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.lastKeyValid() && PlayRecord.this.options.getLastKey() == s.charAt(0)) {
                    PlayRecord.this.curr(PlayRecord.this.options.getInterval());
                    return false;
                }
            }
            if (!PlayRecord.this.options.isNonInterruptable()) {
                if (PlayRecord.this.isPromptActive) {
                    logger.info((Object)String.format("(%s) Tone '%s' has been detected: prompt phase interrupted", PlayRecord.this.getEndpoint().getLocalName(), s));
                    PlayRecord.this.terminatePrompt();
                } else {
                    logger.info((Object)String.format("(%s) Tone '%s' has been detected: collected", PlayRecord.this.getEndpoint().getLocalName(), s));
                }
            } else if (PlayRecord.this.isPromptActive) {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected, waiting for prompt phase termination", PlayRecord.this.getEndpoint().getLocalName(), s));
                if (PlayRecord.this.options.isClearDigits()) {
                    return false;
                }
            } else {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected: collected", PlayRecord.this.getEndpoint().getLocalName(), s));
            }
            return true;
        }
    }

    private class RecordingHandler
    implements RecorderListener {
        private PlayRecord signal;

        protected RecordingHandler(PlayRecord signal) {
            this.signal = signal;
        }

        public void process(RecorderEvent event) {
            block0 : switch (event.getID()) {
                case 2: {
                    switch (event.getQualifier()) {
                        case 1: {
                            if (PlayRecord.this.numberOfAttempts == 1) {
                                PlayRecord.this.oc.fire(this.signal, new Text("rc=328"));
                                break block0;
                            }
                            if (PlayRecord.this.options.hasFailureAnnouncement()) {
                                PlayRecord.this.eventContent = new Text("rc=328");
                                PlayRecord.this.playerMode = PlayerMode.FAILURE;
                                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getFailureAnnouncement());
                                break block0;
                            }
                            PlayRecord.this.oc.fire(this.signal, new Text("rc=328"));
                            break block0;
                        }
                        case 2: {
                            if (PlayRecord.this.numberOfAttempts == 1) {
                                PlayRecord.this.oc.fire(this.signal, new Text("rc=327"));
                                break block0;
                            }
                            if (PlayRecord.this.options.hasNoSpeechReprompt()) {
                                PlayRecord.this.eventContent = new Text("rc=327");
                                PlayRecord.this.playerMode = PlayerMode.FAILURE;
                                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getNoSpeechReprompt());
                                break block0;
                            }
                            if (PlayRecord.this.options.hasFailureAnnouncement()) {
                                PlayRecord.this.eventContent = new Text("rc=327");
                                PlayRecord.this.playerMode = PlayerMode.FAILURE;
                                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getFailureAnnouncement());
                                break block0;
                            }
                            PlayRecord.this.oc.fire(this.signal, new Text("rc=327"));
                        }
                    }
                }
            }
        }
    }

    private class PromptHandler
    implements PlayerListener {
        private PlayRecord signal;

        protected PromptHandler(PlayRecord signal) {
            this.signal = signal;
        }

        public void process(PlayerEvent event) {
            switch (event.getID()) {
                case 1: {
                    if (PlayRecord.this.segCount != 0) break;
                    PlayRecord.this.flushBuffer();
                    break;
                }
                case 2: {
                    if (PlayRecord.this.promptIndex < PlayRecord.this.promptLength - 1) {
                        PlayRecord.this.next(PlayRecord.this.options.getInterval());
                        return;
                    }
                    switch (PlayRecord.this.playerMode) {
                        case PROMPT: {
                            if (!PlayRecord.this.isPromptActive) break;
                            PlayRecord.this.isPromptActive = false;
                            logger.info((Object)String.format("(%s) Prompt phase terminated, start collect/record phase", PlayRecord.this.getEndpoint().getLocalName()));
                            PlayRecord.this.startCollectPhase();
                            if (PlayRecord.this.isCompleted) break;
                            PlayRecord.this.startRecordPhase(PlayRecord.this.options);
                            break;
                        }
                        case SUCCESS: {
                            PlayRecord.this.oc.fire(this.signal, PlayRecord.this.eventContent);
                            PlayRecord.this.reset();
                            PlayRecord.this.isCompleted = true;
                            PlayRecord.this.complete();
                            break;
                        }
                        case FAILURE: {
                            if (PlayRecord.this.numberOfAttempts == 1) {
                                PlayRecord.this.oc.fire(this.signal, PlayRecord.this.eventContent);
                                PlayRecord.this.reset();
                                PlayRecord.this.isCompleted = true;
                                PlayRecord.this.complete();
                                break;
                            }
                            PlayRecord.this.decreaseNa();
                        }
                    }
                    break;
                }
                case 3: {
                    PlayRecord.this.of.fire(this.signal, null);
                    PlayRecord.this.complete();
                }
            }
        }
    }
}

