/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.trunk;

import org.apache.log4j.Logger;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.PipeImpl;
import org.mobicents.media.server.io.ss7.SS7Input;
import org.mobicents.media.server.io.ss7.SS7Output;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.trunk.Options;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.utils.Text;

public class Loopback
extends Signal {
    private Event of = new Event(new Text("of"));
    private volatile Options options;
    private PipeImpl pipe = new PipeImpl();
    private SS7Input ss7Input;
    private SS7Output ss7Output;
    private static final Logger logger = Logger.getLogger(Loopback.class);

    public Loopback(String name) {
        super(name);
        this.of.add(new NotifyImmediately("N"));
    }

    public void execute() {
        this.ss7Input = this.getSS7Input();
        this.ss7Output = this.getSS7Output();
        if (this.ss7Input == null || this.ss7Output == null) {
            this.of.fire(this, new Text("Endpoint is not ss7 endpoint"));
            this.complete();
            return;
        }
        this.options = new Options(this.getTrigger().getParams());
        if (this.options.isDeactivation()) {
            this.pipe.stop();
            this.pipe.disconnect();
        } else {
            this.pipe.connect((MediaSource)this.ss7Input);
            this.pipe.connect((MediaSink)this.ss7Output);
            this.pipe.start();
        }
    }

    public boolean doAccept(Text event) {
        return !this.of.isActive() && this.of.matches(event);
    }

    public void reset() {
        super.reset();
        this.pipe.stop();
        this.pipe.disconnect();
        this.of.reset();
    }

    public void cancel() {
        this.pipe.stop();
        this.pipe.disconnect();
    }

    private SS7Input getSS7Input() {
        return (SS7Input)this.getEndpoint().getResource(MediaType.AUDIO, SS7Input.class);
    }

    private SS7Output getSS7Output() {
        return (SS7Output)this.getEndpoint().getResource(MediaType.AUDIO, SS7Output.class);
    }
}

