/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.MgcpListener;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.controller.CallManager;
import org.mobicents.media.server.mgcp.controller.Configurator;
import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.controller.naming.NamingTree;
import org.mobicents.media.server.mgcp.tx.Transaction;
import org.mobicents.media.server.mgcp.tx.TransactionManager;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaServer;
import org.mobicents.media.server.spi.ServerManager;
import org.mobicents.media.server.spi.listener.TooManyListenersException;

public class Controller
implements MgcpListener,
ServerManager {
    private static final String HOME_DIR = "MMS_HOME";
    private final Logger logger = Logger.getLogger((String)"MGCP");
    private UdpManager udpInterface;
    private int port;
    protected Scheduler scheduler;
    protected MgcpProvider mgcpProvider;
    protected MediaServer server;
    protected NamingTree endpoints = new NamingTree();
    private Configurator configurator;
    private CallManager callManager = new CallManager();
    private TransactionManager txManager;
    private int poolSize = 10;

    public void setUdpInterface(UdpManager udpInterface) {
        this.udpInterface = udpInterface;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServer(MediaServer server) {
        this.logger.info((Object)"Set server");
        this.server = server;
        server.addManager((ServerManager)this);
    }

    public void setScheduler(Scheduler scheduler) {
        this.logger.info((Object)("Set scheduler: " + scheduler));
        this.scheduler = scheduler;
    }

    public void setConfiguration(String url) throws Exception {
        try {
            if (url != null) {
                String home = Controller.getHomeDir();
                if (home == null) {
                    throw new IOException("MMS_HOME not set");
                }
                String path = home + "/conf/" + url;
                FileInputStream stream = new FileInputStream(path);
                this.configurator = new Configurator(stream);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not configure MGCP controller", (Throwable)e);
            throw e;
        }
    }

    public void setConfigurationByURL(URL url) throws Exception {
        try {
            this.configurator = new Configurator(url.openStream());
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not configure MGCP controller", (Throwable)e);
            throw e;
        }
    }

    private static String getHomeDir() {
        String mmsHomeDir = System.getProperty(HOME_DIR);
        if (mmsHomeDir == null) {
            mmsHomeDir = System.getenv(HOME_DIR);
        }
        return mmsHomeDir;
    }

    public void start() {
        this.logger.info((Object)"Starting MGCP controller");
        this.logger.info((Object)"Starting MGCP provider");
        this.mgcpProvider = new MgcpProvider(this.udpInterface, this.port, this.scheduler);
        this.mgcpProvider.activate();
        try {
            this.mgcpProvider.addListener(this);
        }
        catch (TooManyListenersException e) {
            this.logger.error((Object)e);
        }
        this.txManager = new TransactionManager(this.scheduler, this.poolSize);
        this.txManager.setNamingService(this.endpoints);
        this.txManager.setCallManager(this.callManager);
        this.txManager.setMgcpProvider(this.mgcpProvider);
        this.logger.info((Object)"Controller started");
    }

    public void stop() {
        this.mgcpProvider.shutdown();
        this.logger.info((Object)"Controller stopped");
    }

    public void process(MgcpEvent event) {
        int txID = event.getMessage().getTxID();
        Transaction tx = this.txManager.find(txID);
        if (tx != null) {
            tx.process(event);
        }
    }

    public void onStarted(Endpoint endpoint) {
        try {
            MgcpEndpoint mgcpEndpoint = this.configurator.activate(endpoint, this.mgcpProvider, this.udpInterface.getLocalBindAddress(), this.port);
            mgcpEndpoint.setMgcpListener(this);
            this.endpoints.register(mgcpEndpoint);
            this.logger.info((Object)("Endpoint restarted: " + endpoint.getLocalName()));
        }
        catch (Exception e) {
            this.logger.error((Object)("Could not register endpoint: " + endpoint.getLocalName()));
        }
    }

    public void onStopped(Endpoint endpoint) {
    }
}

