/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.params;

import java.util.Collection;
import org.mobicents.media.server.utils.Text;

public class LocalConnectionOptions {
    public static final Text CODECS = new Text("a");
    public static final Text BANDWIDTH = new Text("b");
    public static final Text PACKETIZATION_PERIOD = new Text("p");
    public static final Text TYPE_OF_NETWORK = new Text("nt");
    public static final Text TYPE_OF_SERVICE = new Text("t");
    public static final Text ECHO_CANCELATION = new Text("e");
    public static final Text GAIN_CONTROL = new Text("gc");
    public static final Text SILENCE_SUPPRESSION = new Text("s");
    public static final Text RESOURCE_RESERVATION = new Text("r");
    public static final Text ENCRYPTION_KEY = new Text("k");
    public static final Text DTMF_CLAMP = new Text("x-dc");
    public static final Text LOCAL_NETWORK = new Text("LOCAL");
    public static final Text TRUE = new Text("true");
    private Text codecs = new Text();
    private Text gain = new Text();
    private Text bandwidth = new Text();
    private Text packetizationPeriod = new Text();
    private Text typeOfService = new Text();
    private Text echoCancelation = new Text();
    private Text silenceSuppression = new Text();
    private Text resourceReservation = new Text();
    private Text encryptionKey = new Text();
    private Text dtmfclamp = new Text();
    private Text keyword = new Text();
    private Text value = new Text();
    private Text[] option = new Text[]{this.keyword, this.value};
    private boolean isValid = false;
    private boolean isLocal = false;

    public void setValue(Text text) {
        this.isLocal = false;
        if (text == null) {
            this.isValid = false;
            return;
        }
        this.isValid = true;
        Collection tokens = text.split(',');
        for (Text token : tokens) {
            token.divide(':', this.option);
            if (this.keyword.equals((Object)CODECS)) {
                this.value.copy(this.codecs);
                continue;
            }
            if (this.keyword.equals((Object)BANDWIDTH)) {
                this.value.copy(this.bandwidth);
                continue;
            }
            if (this.keyword.equals((Object)PACKETIZATION_PERIOD)) {
                this.value.copy(this.packetizationPeriod);
                continue;
            }
            if (this.keyword.equals((Object)TYPE_OF_SERVICE)) {
                this.value.copy(this.typeOfService);
                continue;
            }
            if (this.keyword.equals((Object)ECHO_CANCELATION)) {
                this.value.copy(this.echoCancelation);
                continue;
            }
            if (this.keyword.equals((Object)GAIN_CONTROL)) {
                this.value.copy(this.gain);
                continue;
            }
            if (this.keyword.equals((Object)SILENCE_SUPPRESSION)) {
                this.value.copy(this.silenceSuppression);
                continue;
            }
            if (this.keyword.equals((Object)RESOURCE_RESERVATION)) {
                this.value.copy(this.resourceReservation);
                continue;
            }
            if (this.keyword.equals((Object)ENCRYPTION_KEY)) {
                this.value.copy(this.encryptionKey);
                continue;
            }
            if (this.keyword.equals((Object)DTMF_CLAMP)) {
                this.value.copy(this.dtmfclamp);
                continue;
            }
            if (!this.keyword.equals((Object)TYPE_OF_NETWORK) || !this.value.equals((Object)LOCAL_NETWORK)) continue;
            this.isLocal = true;
        }
    }

    public int getGain() {
        return this.isValid ? this.gain.toInteger() : 0;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public boolean getDtmfClamp() {
        if (!this.isValid) {
            return false;
        }
        return this.dtmfclamp.equals((Object)TRUE);
    }
}

