/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.au;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.au.BufferListener;
import org.mobicents.media.server.mgcp.pkg.au.EventBuffer;
import org.mobicents.media.server.mgcp.pkg.au.InteruptPrompt;
import org.mobicents.media.server.mgcp.pkg.au.Options;
import org.mobicents.media.server.mgcp.pkg.au.PlayerMode;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.dtmf.DtmfDetector;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorListener;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.utils.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayCollect
extends Signal {
    private Event oc = new Event(new Text("oc"));
    private Event of = new Event(new Text("of"));
    private Player player;
    private DtmfDetector dtmfDetector;
    private Options options;
    private EventBuffer buffer = new EventBuffer();
    private PromptHandler promptHandler;
    private DtmfHandler dtmfHandler;
    private volatile boolean isPromptActive;
    private Text[] prompt = new Text[10];
    private int promptLength = 0;
    private int promptIndex = 0;
    private static final Logger logger = Logger.getLogger(PlayCollect.class);
    private long firstDigitTimer = 0L;
    private long nextDigitTimer = 0L;
    private long maxDuration = 0L;
    private int numberOfAttempts = 1;
    private Heartbeat heartbeat;
    private int segCount = 0;
    private PlayerMode playerMode = PlayerMode.PROMPT;
    private Text eventContent;

    public PlayCollect(String name) {
        super(name);
        this.oc.add(new NotifyImmediately("N"));
        this.oc.add(new InteruptPrompt("S", this.player));
        this.of.add(new NotifyImmediately("N"));
        this.dtmfHandler = new DtmfHandler(this);
        this.promptHandler = new PromptHandler(this);
    }

    @Override
    public void execute() {
        if (this.getEndpoint().getActiveConnectionsCount() == 0) {
            this.oc.fire(this, new Text("rc=326"));
            this.complete();
            return;
        }
        this.playerMode = PlayerMode.PROMPT;
        this.promptLength = 0;
        this.promptIndex = 0;
        this.segCount = 0;
        this.heartbeat = new Heartbeat(this.getEndpoint().getScheduler(), this);
        this.options = new Options(this.getTrigger().getParams());
        logger.info((Object)String.format("(%s) Prepare digit collect phase", this.getEndpoint().getLocalName()));
        this.prepareCollectPhase(this.options);
        this.firstDigitTimer = this.options.getFirstDigitTimer() > 0L ? this.options.getFirstDigitTimer() : 0L;
        this.nextDigitTimer = this.options.getInterDigitTimer() > 0L ? this.options.getInterDigitTimer() : 0L;
        this.maxDuration = this.options.getMaxDuration() > 0L ? this.options.getMaxDuration() : 0L;
        this.numberOfAttempts = this.options.getNumberOfAttempts() > 1 ? this.options.getNumberOfAttempts() : 1;
        if (this.options.hasPrompt()) {
            logger.info((Object)String.format("(%s) Start prompt phase", this.getEndpoint().getLocalName()));
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
            return;
        }
        logger.info((Object)String.format("(%s) Start collect phase", this.getEndpoint().getLocalName()));
        this.flushBuffer();
        this.startCollectPhase();
    }

    private void startPromptPhase(Collection<Text> promptList) {
        this.player = this.getPlayer();
        try {
            this.player.addListener((PlayerListener)this.promptHandler);
            this.promptLength = promptList.size();
            this.prompt = promptList.toArray(this.prompt);
            this.player.setURL(this.prompt[0].toString());
            this.player.activate();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, new Text("Too many listeners"));
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void terminatePrompt() {
        if (this.promptLength > 0) {
            this.promptIndex = this.promptLength - 1;
        }
        if (this.player != null) {
            this.player.deactivate();
            this.player.removeListener((PlayerListener)this.promptHandler);
            this.player = null;
        }
    }

    private void prepareCollectPhase(Options options) {
        this.dtmfDetector = this.getDetector();
        if (options.isClearDigits()) {
            this.dtmfDetector.clearDigits();
        }
        this.buffer.reset();
        this.buffer.setListener(this.dtmfHandler);
        this.buffer.setPatterns(options.getDigitPattern());
        if (options.getMaxDigitsNumber() > 0) {
            this.buffer.setCount(options.getMaxDigitsNumber());
        } else {
            this.buffer.setCount(options.getDigitsNumber());
        }
    }

    private void flushBuffer() {
        try {
            this.dtmfDetector.addListener((DtmfDetectorListener)this.buffer);
            this.dtmfDetector.flushBuffer();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, new Text("Too many listeners for DTMF detector"));
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
    }

    private void startCollectPhase() {
        if (this.firstDigitTimer > 0L || this.maxDuration > 0L) {
            if (this.firstDigitTimer > 0L) {
                this.heartbeat.setTtl((int)(this.firstDigitTimer / 100000000L));
            } else {
                this.heartbeat.setTtl(-1);
            }
            if (this.maxDuration > 0L) {
                this.heartbeat.setOverallTtl((int)(this.maxDuration / 100000000L));
            } else {
                this.heartbeat.setOverallTtl(-1);
            }
            this.heartbeat.activate();
            this.getEndpoint().getScheduler().submitHeatbeat((Task)this.heartbeat);
        }
        this.buffer.activate();
        this.buffer.flush();
    }

    private void terminateCollectPhase() {
        if (this.dtmfDetector != null) {
            this.dtmfDetector.removeListener((DtmfDetectorListener)this.buffer);
            this.buffer.passivate();
            this.buffer.clear();
            this.dtmfDetector = null;
        }
    }

    private void terminate() {
        this.isPromptActive = false;
        this.terminatePrompt();
        this.terminateCollectPhase();
        if (this.heartbeat != null) {
            this.heartbeat.disable();
        }
    }

    @Override
    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    @Override
    public void cancel() {
        if (this.heartbeat != null) {
            this.heartbeat.disable();
        }
        this.isPromptActive = false;
        this.terminate();
    }

    private Player getPlayer() {
        Endpoint endpoint = this.getEndpoint();
        return (Player)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.PLAYER);
    }

    private DtmfDetector getDetector() {
        Endpoint endpoint = this.getEndpoint();
        return (DtmfDetector)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.DTMF_DETECTOR);
    }

    @Override
    public void reset() {
        super.reset();
        this.isPromptActive = false;
        this.terminate();
        this.oc.reset();
        this.of.reset();
    }

    private void next(long delay) {
        ++this.segCount;
        ++this.promptIndex;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player next with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void prev(long delay) {
        ++this.segCount;
        --this.promptIndex;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player prev with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void curr(long delay) {
        ++this.segCount;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player curr with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void first(long delay) {
        ++this.segCount;
        this.promptIndex = 0;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player first with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void last(long delay) {
        ++this.segCount;
        this.promptIndex = this.promptLength - 1;
        try {
            String url = this.prompt[this.promptIndex].toString();
            logger.info((Object)String.format("(%s) Processing player last with url - %s", this.getEndpoint().getLocalName(), url));
            this.player.setURL(url);
            this.player.setInitialDelay(delay * 1000000L);
            this.player.start();
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text(e.getMessage()));
            return;
        }
    }

    private void decreaseNa() {
        --this.numberOfAttempts;
        if (this.options.hasReprompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getReprompt());
            this.heartbeat.disable();
        } else if (this.options.hasPrompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
            this.heartbeat.disable();
        } else {
            this.startCollectPhase();
        }
    }

    private class Heartbeat
    extends Task {
        private AtomicInteger ttl;
        private AtomicInteger overallTtl;
        private AtomicBoolean active;
        private Scheduler scheduler;
        private Signal signal;

        public Heartbeat(Scheduler scheduler, Signal signal) {
            super(scheduler);
            this.ttl = new AtomicInteger(-1);
            this.overallTtl = new AtomicInteger(-1);
            this.active = new AtomicBoolean(false);
            this.scheduler = scheduler;
            this.signal = signal;
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void setTtl(int value) {
            this.ttl.set(value);
        }

        public void setOverallTtl(int value) {
            this.overallTtl.set(value);
        }

        public void disable() {
            this.active.set(false);
        }

        public void activate() {
            this.active.set(true);
        }

        public boolean isActive() {
            return this.active.get();
        }

        public long perform() {
            if (!this.active.get()) {
                return 0L;
            }
            int ttlValue = this.ttl.get();
            int overallTtlValue = this.overallTtl.get();
            if (ttlValue != 0 && overallTtlValue != 0) {
                if (ttlValue > 0) {
                    this.ttl.set(ttlValue - 1);
                }
                if (overallTtlValue > 0) {
                    this.overallTtl.set(overallTtlValue - 1);
                }
                this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            logger.info((Object)String.format("(%s) Timeout expired waiting for dtmf", PlayCollect.this.getEndpoint().getLocalName()));
            if (PlayCollect.this.numberOfAttempts == 1) {
                if (ttlValue == 0) {
                    int length = PlayCollect.this.buffer.getSequence().length();
                    if (length >= PlayCollect.this.options.getDigitsNumber()) {
                        if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                            PlayCollect.this.eventContent = new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence());
                            PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                            PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
                        } else {
                            PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence()));
                            PlayCollect.this.reset();
                            PlayCollect.this.complete();
                        }
                    } else if (length > 0) {
                        if (PlayCollect.this.options.hasNoDigitsReprompt()) {
                            PlayCollect.this.eventContent = new Text("rc=326 dc=" + PlayCollect.this.buffer.getSequence());
                            PlayCollect.this.playerMode = PlayerMode.FAILURE;
                            PlayCollect.this.startPromptPhase(PlayCollect.this.options.getNoDigitsReprompt());
                        } else if (PlayCollect.this.options.hasFailureAnnouncement()) {
                            PlayCollect.this.eventContent = new Text("rc=326 dc=" + PlayCollect.this.buffer.getSequence());
                            PlayCollect.this.playerMode = PlayerMode.FAILURE;
                            PlayCollect.this.startPromptPhase(PlayCollect.this.options.getFailureAnnouncement());
                        } else {
                            PlayCollect.this.oc.fire(this.signal, new Text("rc=326 dc=" + PlayCollect.this.buffer.getSequence()));
                            PlayCollect.this.reset();
                            PlayCollect.this.complete();
                        }
                    } else if (PlayCollect.this.options.hasNoDigitsReprompt()) {
                        PlayCollect.this.eventContent = new Text("rc=326");
                        PlayCollect.this.playerMode = PlayerMode.FAILURE;
                        PlayCollect.this.startPromptPhase(PlayCollect.this.options.getNoDigitsReprompt());
                    } else if (PlayCollect.this.options.hasFailureAnnouncement()) {
                        PlayCollect.this.eventContent = new Text("rc=326");
                        PlayCollect.this.playerMode = PlayerMode.FAILURE;
                        PlayCollect.this.startPromptPhase(PlayCollect.this.options.getFailureAnnouncement());
                    } else {
                        PlayCollect.this.oc.fire(this.signal, new Text("rc=326"));
                        PlayCollect.this.reset();
                        PlayCollect.this.complete();
                    }
                } else if (PlayCollect.this.options.hasNoDigitsReprompt()) {
                    PlayCollect.this.eventContent = new Text("rc=330");
                    PlayCollect.this.playerMode = PlayerMode.FAILURE;
                    PlayCollect.this.startPromptPhase(PlayCollect.this.options.getNoDigitsReprompt());
                } else if (PlayCollect.this.options.hasFailureAnnouncement()) {
                    PlayCollect.this.eventContent = new Text("rc=330");
                    PlayCollect.this.playerMode = PlayerMode.FAILURE;
                    PlayCollect.this.startPromptPhase(PlayCollect.this.options.getFailureAnnouncement());
                } else {
                    PlayCollect.this.oc.fire(this.signal, new Text("rc=330"));
                    PlayCollect.this.reset();
                    PlayCollect.this.complete();
                }
            } else {
                PlayCollect.this.decreaseNa();
            }
            return 0L;
        }
    }

    private class DtmfHandler
    implements BufferListener {
        private PlayCollect signal;

        public DtmfHandler(PlayCollect signal) {
            this.signal = signal;
        }

        public void patternMatches(int index, String s) {
            logger.info((Object)String.format("(%s) Collect phase: pattern has been detected", PlayCollect.this.getEndpoint().getLocalName()));
            if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                PlayCollect.this.eventContent = new Text("rc=100 dc=" + s + " pi=" + index);
                PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
            } else {
                PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + s + " pi=" + index));
                PlayCollect.this.reset();
                PlayCollect.this.complete();
            }
        }

        public void countMatches(String s) {
            logger.info((Object)String.format("(%s) Collect phase: max number of digits has been detected", PlayCollect.this.getEndpoint().getLocalName()));
            if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                PlayCollect.this.eventContent = new Text("rc=100 dc=" + s);
                PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
            } else {
                PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + s));
                PlayCollect.this.reset();
                PlayCollect.this.complete();
            }
        }

        public boolean tone(String s) {
            if (PlayCollect.this.options.getMaxDigitsNumber() > 0 && s.charAt(0) == PlayCollect.this.options.getEndInputKey() && PlayCollect.this.buffer.length() >= PlayCollect.this.options.getDigitsNumber()) {
                logger.info((Object)String.format("(%s) End Input Tone '%s' has been detected", PlayCollect.this.getEndpoint().getLocalName(), s));
                if (PlayCollect.this.options.hasSuccessAnnouncement()) {
                    if (PlayCollect.this.options.isIncludeEndInputKey()) {
                        PlayCollect.this.eventContent = new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + s);
                    } else {
                        PlayCollect.this.eventContent = new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence());
                    }
                    PlayCollect.this.playerMode = PlayerMode.SUCCESS;
                    PlayCollect.this.startPromptPhase(PlayCollect.this.options.getSuccessAnnouncement());
                } else {
                    if (PlayCollect.this.options.isIncludeEndInputKey()) {
                        PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence() + s));
                    } else {
                        PlayCollect.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayCollect.this.buffer.getSequence()));
                    }
                    PlayCollect.this.heartbeat.disable();
                    PlayCollect.this.reset();
                    PlayCollect.this.complete();
                }
                return true;
            }
            logger.info((Object)String.format("(%s) Tone '%s' has been detected", PlayCollect.this.getEndpoint().getLocalName(), s));
            if (PlayCollect.this.isPromptActive) {
                if (PlayCollect.this.options.prevKeyValid() && PlayCollect.this.options.getPrevKey() == s.charAt(0)) {
                    PlayCollect.this.prev(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.firstKeyValid() && PlayCollect.this.options.getFirstKey() == s.charAt(0)) {
                    PlayCollect.this.first(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.currKeyValid() && PlayCollect.this.options.getCurrKey() == s.charAt(0)) {
                    PlayCollect.this.curr(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.nextKeyValid() && PlayCollect.this.options.getNextKey() == s.charAt(0)) {
                    PlayCollect.this.first(PlayCollect.this.options.getInterval());
                    return false;
                }
                if (PlayCollect.this.options.lastKeyValid() && PlayCollect.this.options.getLastKey() == s.charAt(0)) {
                    PlayCollect.this.curr(PlayCollect.this.options.getInterval());
                    return false;
                }
            }
            if (!PlayCollect.this.options.isNonInterruptable()) {
                if (PlayCollect.this.isPromptActive) {
                    logger.info((Object)String.format("(%s) Tone '%s' has been detected: prompt phase interrupted", PlayCollect.this.getEndpoint().getLocalName(), s));
                    PlayCollect.this.terminatePrompt();
                } else {
                    logger.info((Object)String.format("(%s) Tone '%s' has been detected: collected", PlayCollect.this.getEndpoint().getLocalName(), s));
                }
            } else if (PlayCollect.this.isPromptActive) {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected, waiting for prompt phase termination", PlayCollect.this.getEndpoint().getLocalName(), s));
                if (PlayCollect.this.options.isClearDigits()) {
                    return false;
                }
            } else {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected: collected", PlayCollect.this.getEndpoint().getLocalName(), s));
            }
            if (PlayCollect.this.nextDigitTimer > 0L) {
                PlayCollect.this.heartbeat.setTtl((int)(PlayCollect.this.nextDigitTimer / 100000000L));
                if (!PlayCollect.this.heartbeat.isActive()) {
                    PlayCollect.this.heartbeat.activate();
                    PlayCollect.this.getEndpoint().getScheduler().submitHeatbeat((Task)PlayCollect.this.heartbeat);
                }
            } else if (PlayCollect.this.maxDuration == 0L) {
                PlayCollect.this.heartbeat.disable();
            }
            return true;
        }
    }

    private class PromptHandler
    implements PlayerListener {
        private PlayCollect signal;

        protected PromptHandler(PlayCollect signal) {
            this.signal = signal;
        }

        public void process(PlayerEvent event) {
            switch (event.getID()) {
                case 1: {
                    if (PlayCollect.this.segCount != 0) break;
                    PlayCollect.this.flushBuffer();
                    break;
                }
                case 2: {
                    if (PlayCollect.this.promptIndex < PlayCollect.this.promptLength - 1) {
                        PlayCollect.this.next(PlayCollect.this.options.getInterval());
                        return;
                    }
                    switch (PlayCollect.this.playerMode) {
                        case PROMPT: {
                            if (!PlayCollect.this.isPromptActive) break;
                            PlayCollect.this.isPromptActive = false;
                            logger.info((Object)String.format("(%s) Prompt phase terminated, start collect phase", PlayCollect.this.getEndpoint().getLocalName()));
                            PlayCollect.this.startCollectPhase();
                            break;
                        }
                        case SUCCESS: {
                            PlayCollect.this.oc.fire(this.signal, PlayCollect.this.eventContent);
                            PlayCollect.this.reset();
                            PlayCollect.this.complete();
                            break;
                        }
                        case FAILURE: {
                            if (PlayCollect.this.numberOfAttempts == 1) {
                                PlayCollect.this.oc.fire(this.signal, PlayCollect.this.eventContent);
                                PlayCollect.this.reset();
                                PlayCollect.this.complete();
                                break;
                            }
                            PlayCollect.this.decreaseNa();
                        }
                    }
                    break;
                }
                case 3: {
                    PlayCollect.this.of.fire(this.signal, null);
                    PlayCollect.this.complete();
                }
            }
        }
    }
}

