/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.controller.CallManager;
import org.mobicents.media.server.mgcp.controller.naming.NamingTree;
import org.mobicents.media.server.mgcp.tx.Transaction;
import org.mobicents.media.server.scheduler.ConcurrentLinkedList;
import org.mobicents.media.server.scheduler.Scheduler;

public class TransactionManager {
    private static AtomicInteger ID = new AtomicInteger(1);
    private ConcurrentLinkedList<Transaction> pool = new ConcurrentLinkedList();
    private ConcurrentHashMap<Integer, Transaction> active;
    private Scheduler scheduler;
    protected MgcpProvider provider;
    protected NamingTree namingService;
    protected CallManager callManager;

    public TransactionManager(Scheduler scheduler, int size) {
        this.scheduler = scheduler;
        this.active = new ConcurrentHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.pool.offer((Object)new Transaction(this));
        }
    }

    public void setNamingService(NamingTree namingService) {
        this.namingService = namingService;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public long getTime() {
        return this.scheduler.getClock().getTime();
    }

    public void setCallManager(CallManager callManager) {
        this.callManager = callManager;
    }

    public void setMgcpProvider(MgcpProvider provider) {
        this.provider = provider;
    }

    public Transaction find(int id) {
        Transaction currTransaction = this.active.get(id);
        if (currTransaction != null) {
            return currTransaction;
        }
        return this.begin(id);
    }

    private Transaction begin(int id) {
        Transaction t = (Transaction)this.pool.poll();
        if (t == null) {
            return t;
        }
        t.id = id;
        this.active.put(t.id, t);
        return t;
    }

    protected void terminate(Transaction t) {
        this.active.remove(t.id);
        t.id = 0;
        this.pool.offer((Object)t);
    }

    protected int nextID() {
        return ID.incrementAndGet();
    }

    protected int remainder() {
        return this.pool.size();
    }
}

