/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx;

import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.controller.MgcpCall;
import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.controller.naming.UnknownEndpointException;
import org.mobicents.media.server.mgcp.tx.Action;
import org.mobicents.media.server.mgcp.tx.ActionListener;
import org.mobicents.media.server.mgcp.tx.TransactionManager;
import org.mobicents.media.server.mgcp.tx.cmd.ActionSelector;
import org.mobicents.media.server.mgcp.tx.cmd.MgcpCommandException;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.utils.Text;

public class Transaction
implements ActionListener {
    protected int id;
    protected int uniqueId;
    protected boolean completed = false;
    private TransactionManager txManager;
    private ActionSelector selector;
    private Action action;
    private Exception lastError;
    private static final Logger logger = Logger.getLogger((String)"MGCP");

    protected Transaction(TransactionManager txManager) {
        this.txManager = txManager;
        this.selector = new ActionSelector(txManager.scheduler());
    }

    public Scheduler scheduler() {
        return this.txManager.scheduler();
    }

    public int getId() {
        return this.id;
    }

    public MgcpProvider getProvider() {
        return this.txManager.provider;
    }

    public MgcpCall getCall(Integer id, boolean isNew) {
        return this.txManager.callManager.getCall(id, isNew);
    }

    public int find(Text name, MgcpEndpoint[] endpoints) throws UnknownEndpointException {
        return this.txManager.namingService.find(name, endpoints);
    }

    public Exception getLastError() {
        return this.lastError;
    }

    public long getTime() {
        return this.txManager.getTime();
    }

    public void process(MgcpEvent event) {
        this.action = this.selector.getAction(event);
        if (this.action != null) {
            logger.info((Object)("tx=" + this.id + " Started, message= " + event.getMessage() + ", call agent = " + event.getAddress()));
            this.action.setEvent(event);
            this.process(this.action);
        } else {
            event.recycle();
            this.onComplete();
        }
    }

    protected void process(Action action) {
        this.action = action;
        action.listener = this;
        action.start(this);
    }

    protected int nextID() {
        return this.txManager.nextID();
    }

    public void onComplete() {
        logger.info((Object)("tx=" + this.id + " was executed normaly"));
        if (this.action != null && this.action.getEvent() != null) {
            this.action.getEvent().recycle();
            this.action = null;
        }
        if (!this.completed) {
            this.completed = true;
            this.txManager.terminate(this);
        }
    }

    public void onFailure(Exception e) {
        logger.error((Object)("tx=" + this.id + " Failed"), (Throwable)e);
        if (e != null && e instanceof MgcpCommandException) {
            this.lastError = e;
        } else {
            Text msg = e.getMessage() != null ? new Text(e.getMessage()) : new Text("Unknown");
            this.lastError = new MgcpCommandException(400, msg);
        }
        this.action.rollback();
    }

    public void onRollback() {
        logger.info((Object)("tx=" + this.id + " Rolled back"));
        if (this.action.getEvent() != null) {
            this.action.getEvent().recycle();
            this.action = null;
        }
        if (!this.completed) {
            this.completed = true;
            this.txManager.terminate(this);
        }
    }
}

