/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx.cmd;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.controller.naming.UnknownEndpointException;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.MgcpResponse;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.mgcp.tx.Action;
import org.mobicents.media.server.mgcp.tx.cmd.MgcpCommandException;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.scheduler.TaskChain;
import org.mobicents.media.server.utils.Text;

public class EndpointConfigurationCmd
extends Action {
    private static final Text SUCCESS = new Text("Success");
    private static final Text MU_LAW = new Text("e:mu");
    private static final Text A_LAW = new Text("e:A");
    private static final Text BEARER_INFORMATION_MISSING = new Text("Missing bearer information value");
    private static final Text INVALID_BEARER_INFORMATION = new Text("Invalid bearer information value");
    private MgcpRequest request;
    private Text localName = new Text();
    private Text domainName = new Text();
    private Text[] endpointName = new Text[]{this.localName, this.domainName};
    private MgcpEndpoint endpoint;
    private MgcpEndpoint[] endpoints = new MgcpEndpoint[1];
    private TaskChain handler;
    private Scheduler scheduler;
    private int code;
    private Text message;
    private static final Logger logger = Logger.getLogger(EndpointConfigurationCmd.class);

    public EndpointConfigurationCmd(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.handler = new TaskChain(2, scheduler);
        Configurator configurator = new Configurator();
        Responder responder = new Responder();
        this.handler.add((Task)configurator);
        this.handler.add((Task)responder);
        ErrorHandler errorHandler = new ErrorHandler();
        this.setActionHandler(this.handler);
        this.setRollbackHandler(errorHandler);
    }

    private class ErrorHandler
    extends Task {
        public int getQueueNumber() {
            EndpointConfigurationCmd.this.scheduler;
            return Scheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            EndpointConfigurationCmd.this.code = ((MgcpCommandException)EndpointConfigurationCmd.this.transaction().getLastError()).getCode();
            EndpointConfigurationCmd.this.message = ((MgcpCommandException)EndpointConfigurationCmd.this.transaction().getLastError()).getErrorMessage();
            MgcpEvent evt = EndpointConfigurationCmd.this.transaction().getProvider().createEvent(2, EndpointConfigurationCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(EndpointConfigurationCmd.this.code);
            response.setResponseString(EndpointConfigurationCmd.this.message);
            response.setTxID(EndpointConfigurationCmd.this.transaction().getId());
            try {
                EndpointConfigurationCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Responder
    extends Task {
        public int getQueueNumber() {
            EndpointConfigurationCmd.this.scheduler;
            return Scheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            MgcpEvent evt = EndpointConfigurationCmd.this.transaction().getProvider().createEvent(2, EndpointConfigurationCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(200);
            response.setResponseString(SUCCESS);
            response.setTxID(EndpointConfigurationCmd.this.transaction().getId());
            try {
                EndpointConfigurationCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Configurator
    extends Task {
        public int getQueueNumber() {
            EndpointConfigurationCmd.this.scheduler;
            return Scheduler.MANAGEMENT_QUEUE;
        }

        public long perform() {
            EndpointConfigurationCmd.this.request = (MgcpRequest)EndpointConfigurationCmd.this.getEvent().getMessage();
            Parameter bearerInformation = EndpointConfigurationCmd.this.request.getParameter(Parameter.BARER_INFORMATION);
            if (bearerInformation == null) {
                throw new MgcpCommandException(510, BEARER_INFORMATION_MISSING);
            }
            boolean isALaw = false;
            if (!bearerInformation.getValue().equals((Object)MU_LAW)) {
                if (bearerInformation.getValue().equals((Object)A_LAW)) {
                    isALaw = true;
                } else {
                    throw new MgcpCommandException(510, INVALID_BEARER_INFORMATION);
                }
            }
            EndpointConfigurationCmd.this.request.getEndpoint().divide('@', EndpointConfigurationCmd.this.endpointName);
            try {
                int n = EndpointConfigurationCmd.this.transaction().find(EndpointConfigurationCmd.this.localName, EndpointConfigurationCmd.this.endpoints);
                if (n == 0) {
                    throw new MgcpCommandException(410, new Text("Endpoint not available"));
                }
            }
            catch (UnknownEndpointException e) {
                throw new MgcpCommandException(500, new Text("Endpoint not available"));
            }
            EndpointConfigurationCmd.this.endpoint = EndpointConfigurationCmd.this.endpoints[0];
            EndpointConfigurationCmd.this.endpoint.configure(isALaw);
            return 0L;
        }
    }
}

