/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.au;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.au.Options;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.utils.Text;

public class Play
extends Signal
implements PlayerListener {
    private Event oc = new Event(new Text("oc"));
    private Event of = new Event(new Text("of"));
    private Player player;
    private volatile Options options;
    private int repeatCount;
    private int segCount;
    private long delay;
    private String uri;
    private Iterator<Text> segments;
    private static final Logger logger = Logger.getLogger(Play.class);
    private Semaphore terminateSemaphore = new Semaphore(1);

    public Play(String name) {
        super(name);
        this.oc.add(new NotifyImmediately("N"));
        this.of.add(new NotifyImmediately("N"));
    }

    public void execute() {
        this.player = this.getPlayer();
        if (this.player == null) {
            this.of.fire(this, new Text("Endpoint has no player"));
            this.complete();
            return;
        }
        try {
            this.player.addListener((PlayerListener)this);
        }
        catch (TooManyListenersException e) {
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
        }
        this.options = Options.allocate(this.getTrigger().getParams());
        this.delay = 0L;
        this.segments = this.options.getSegments().iterator();
        this.repeatCount = this.options.getRepeatCount();
        this.segCount = 0;
        this.uri = this.segments.next().toString();
        this.startAnnouncementPhase();
    }

    private void startAnnouncementPhase() {
        logger.info((Object)String.format("(%s) Start announcement (segment=%d)", this.getEndpoint().getLocalName(), this.segCount));
        try {
            this.player.setURL(this.uri);
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.of.fire(this, new Text("rc=301"));
            this.complete();
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.of.fire(this, new Text("rc=312"));
            this.complete();
            return;
        }
        if (this.options.getDuration() != -1L) {
            this.player.setDuration(this.options.getDuration());
        }
        if (this.options.getOffset() > 0L) {
            this.player.setMediaTime(this.options.getOffset());
        }
        this.player.setInitialDelay(this.delay);
        this.player.activate();
    }

    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    public void cancel() {
        this.terminate();
    }

    private Player getPlayer() {
        Endpoint endpoint = this.getEndpoint();
        return (Player)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.PLAYER);
    }

    public void reset() {
        super.reset();
        this.terminate();
        this.oc.reset();
        this.of.reset();
    }

    private void terminate() {
        try {
            this.terminateSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.player != null) {
            this.player.removeListener((PlayerListener)this);
            this.player.deactivate();
            this.player = null;
        }
        if (this.options != null) {
            Options.recycle(this.options);
            this.options = null;
        }
        this.terminateSemaphore.release();
    }

    private void repeat(long delay) {
        this.delay = delay;
        this.startAnnouncementPhase();
    }

    private void next(long delay) {
        this.uri = this.segments.next().toString();
        ++this.segCount;
        this.delay = delay;
        this.startAnnouncementPhase();
    }

    public void process(PlayerEvent event) {
        switch (event.getID()) {
            case 2: {
                logger.info((Object)String.format("(%s) Announcement (segment=%d) has completed", this.getEndpoint().getLocalName(), this.segCount));
                --this.repeatCount;
                if (this.repeatCount > 0) {
                    this.repeat(this.options.getInterval());
                    return;
                }
                if (this.segments.hasNext()) {
                    this.next(this.options.getInterval());
                    return;
                }
                this.terminate();
                this.oc.fire(this, new Text("rc=100"));
                this.complete();
                break;
            }
            case 3: {
                this.terminate();
                this.oc.fire(this, null);
                this.complete();
            }
        }
    }
}

