/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx;

import java.net.InetSocketAddress;
import org.mobicents.media.server.concurrent.Lock;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.controller.CallManager;
import org.mobicents.media.server.mgcp.controller.naming.NamingTree;
import org.mobicents.media.server.mgcp.tx.Transaction;
import org.mobicents.media.server.mgcp.tx.TransactionManager;
import org.mobicents.media.server.scheduler.Scheduler;

public class GlobalTransactionManager {
    private GlobalTransactionManager[] subManager;
    private TransactionManager[] managers;
    protected MgcpProvider provider;
    private Scheduler scheduler;
    private NamingTree namingService;
    private int poolSize;
    private Lock lock = new Lock();

    public GlobalTransactionManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setNamingService(NamingTree namingService) {
        this.namingService = namingService;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public long getTime() {
        return this.scheduler.getClock().getTime();
    }

    public void setMgcpProvider(MgcpProvider provider) {
        this.provider = provider;
    }

    public Transaction find(InetSocketAddress source, int id) {
        return this.find(source.getAddress().getAddress(), source.getPort(), 0, id);
    }

    private Transaction find(byte[] address, int port, int level, int id) {
        if (level == address.length - 1) {
            this.checkPort(port - 1);
            return this.managers[port - 1].find(id);
        }
        int intIndex = address[level] & 0xFF;
        this.checkAddress(intIndex);
        return this.subManager[intIndex].find(address, port, level + 1, id);
    }

    public Transaction allocateNew(InetSocketAddress source, int id) {
        return this.allocateNew(source.getAddress().getAddress(), source.getPort(), 0, id);
    }

    private Transaction allocateNew(byte[] address, int port, int level, int id) {
        if (level == address.length - 1) {
            this.checkPort(port - 1);
            Transaction old = this.managers[port - 1].find(id);
            if (old == null) {
                return this.managers[port - 1].allocateNew(id);
            }
            return null;
        }
        int intIndex = address[level] & 0xFF;
        this.checkAddress(intIndex);
        return this.subManager[intIndex].allocateNew(address, port, level + 1, id);
    }

    public TransactionManager createTransactionManager() {
        TransactionManager txManager = new TransactionManager(this.scheduler, this.poolSize);
        txManager.setNamingService(this.namingService);
        txManager.setCallManager(new CallManager());
        txManager.setMgcpProvider(this.provider);
        txManager.start();
        return txManager;
    }

    private void checkPort(int portIndex) {
        if (this.managers == null) {
            try {
                this.lock.lock();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.managers == null) {
                this.managers = new TransactionManager[65536];
                this.managers[portIndex] = this.createTransactionManager();
            }
            this.lock.unlock();
        } else if (this.managers[portIndex] == null) {
            try {
                this.lock.lock();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.managers[portIndex] == null) {
                this.managers[portIndex] = this.createTransactionManager();
            }
            this.lock.unlock();
        }
    }

    private void checkAddress(int intIndex) {
        if (this.subManager == null) {
            try {
                this.lock.lock();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.subManager == null) {
                this.subManager = new GlobalTransactionManager[256];
                this.subManager[intIndex] = new GlobalTransactionManager(this.scheduler);
                this.subManager[intIndex].setMgcpProvider(this.provider);
                this.subManager[intIndex].setNamingService(this.namingService);
                this.subManager[intIndex].setPoolSize(this.poolSize);
            }
            this.lock.unlock();
        } else if (this.subManager[intIndex] == null) {
            try {
                this.lock.lock();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.subManager[intIndex] == null) {
                this.subManager[intIndex] = new GlobalTransactionManager(this.scheduler);
                this.subManager[intIndex].setMgcpProvider(this.provider);
                this.subManager[intIndex].setNamingService(this.namingService);
                this.subManager[intIndex].setPoolSize(this.poolSize);
            }
            this.lock.unlock();
        }
    }
}

