/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.dtmf;

import org.mobicents.media.ComponentType;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.dtmf.DtmfDetector;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorListener;
import org.mobicents.media.server.spi.dtmf.DtmfEvent;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.utils.Text;

public abstract class AbstractDtmfEvent
extends Signal
implements DtmfDetectorListener {
    private DtmfDetector dtmfDetector;
    protected Event tone = this.getTone();

    public AbstractDtmfEvent(String name) {
        super(name);
        this.tone.add(new NotifyImmediately("N"));
    }

    @Override
    public void execute() {
        this.dtmfDetector = this.getDetector();
        if (this.dtmfDetector == null) {
            return;
        }
        try {
            this.dtmfDetector.addListener((DtmfDetectorListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    @Override
    public boolean doAccept(Text event) {
        boolean b;
        boolean bl = b = !this.tone.isActive() && this.tone.matches(event);
        if (b) {
            this.execute();
        }
        return b;
    }

    @Override
    public void cancel() {
        if (this.dtmfDetector != null) {
            this.dtmfDetector.removeListener((DtmfDetectorListener)this);
            this.dtmfDetector = null;
        }
    }

    public void process(DtmfEvent event) {
        this.onEvent(event.getTone());
    }

    @Override
    public void reset() {
        this.tone.reset();
    }

    public abstract void onEvent(String var1);

    protected abstract Event getTone();

    private DtmfDetector getDetector() {
        Endpoint endpoint = this.getEndpoint();
        return (DtmfDetector)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.DTMF_DETECTOR);
    }
}

