/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.trunk;

import org.apache.log4j.Logger;
import org.mobicents.media.core.endpoints.BaseSS7EndpointImpl;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.trunk.Options;
import org.mobicents.media.server.utils.Text;

public class Loopback
extends Signal {
    private Event of = new Event(new Text("of"));
    private volatile Options options;
    private static final Logger logger = Logger.getLogger(Loopback.class);

    public Loopback(String name) {
        super(name);
        this.of.add(new NotifyImmediately("N"));
    }

    @Override
    public void execute() {
        if (!(this.getEndpoint() instanceof BaseSS7EndpointImpl)) {
            this.of.fire(this, new Text("Endpoint is not ss7 endpoint"));
            this.complete();
            return;
        }
        this.options = new Options(this.getTrigger().getParams());
        if (this.options.isDeactivation()) {
            ((BaseSS7EndpointImpl)this.getEndpoint()).setLoop(false);
        } else {
            ((BaseSS7EndpointImpl)this.getEndpoint()).setLoop(true);
        }
    }

    @Override
    public boolean doAccept(Text event) {
        return !this.of.isActive() && this.of.matches(event);
    }

    @Override
    public void reset() {
        super.reset();
        ((BaseSS7EndpointImpl)this.getEndpoint()).setLoop(false);
        this.of.reset();
    }

    @Override
    public void cancel() {
        ((BaseSS7EndpointImpl)this.getEndpoint()).setLoop(false);
    }
}

