/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.controller.CallManager;
import org.mobicents.media.server.mgcp.controller.naming.NamingTree;
import org.mobicents.media.server.mgcp.tx.Transaction;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;

public class TransactionManager {
    private static AtomicInteger ID = new AtomicInteger(1);
    private ConcurrentCyclicFIFO<Transaction> pool = new ConcurrentCyclicFIFO();
    private static final int cacheSize = 5;
    private ConcurrentCyclicFIFO<Transaction>[] cache = new ConcurrentCyclicFIFO[5];
    private int cleanIndex = 0;
    private ConcurrentMap<Transaction> active;
    private Scheduler scheduler;
    protected MgcpProvider provider;
    protected NamingTree namingService;
    protected CallManager callManager;
    private Heartbeat cacheHeartbeat;

    public TransactionManager(Scheduler scheduler, int size) {
        int i;
        this.scheduler = scheduler;
        this.active = new ConcurrentMap();
        for (i = 0; i < size; ++i) {
            this.pool.offer((Object)new Transaction(this));
        }
        for (i = 0; i < this.cache.length; ++i) {
            this.cache[i] = new ConcurrentCyclicFIFO();
        }
        this.cacheHeartbeat = new Heartbeat();
    }

    public void start() {
        this.scheduler.submitHeatbeat((Task)this.cacheHeartbeat);
    }

    public void setNamingService(NamingTree namingService) {
        this.namingService = namingService;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public long getTime() {
        return this.scheduler.getClock().getTime();
    }

    public void setCallManager(CallManager callManager) {
        this.callManager = callManager;
    }

    public void setMgcpProvider(MgcpProvider provider) {
        this.provider = provider;
    }

    public Transaction find(int id) {
        Transaction currTransaction = (Transaction)this.active.get((Object)id);
        return currTransaction;
    }

    public Transaction findByTransactionNumber(int transactionNumber) {
        Iterator transactions = this.active.valuesIterator();
        while (transactions.hasNext()) {
            Transaction transaction = (Transaction)transactions.next();
            if (transaction.getId() != transactionNumber) continue;
            return transaction;
        }
        return null;
    }

    public Transaction allocateNew(int id) {
        Transaction t = this.begin(ID.getAndIncrement());
        if (t != null) {
            t.id = id;
        }
        return t;
    }

    private Transaction begin(int id) {
        Transaction t = (Transaction)this.pool.poll();
        if (t == null) {
            t = new Transaction(this);
        }
        t.uniqueId = id;
        this.active.put((Object)t.uniqueId, (Object)t);
        return t;
    }

    protected void terminate(Transaction t) {
        this.cache[this.cleanIndex].offer((Object)t);
    }

    protected int nextID() {
        return ID.incrementAndGet();
    }

    protected int remainder() {
        return this.pool.size();
    }

    private class Heartbeat
    extends Task {
        int queueToClean;

        public long perform() {
            this.queueToClean = (TransactionManager.this.cleanIndex + 1) % 5;
            Transaction current = (Transaction)TransactionManager.this.cache[this.queueToClean].poll();
            while (current != null) {
                TransactionManager.this.active.remove((Object)current.uniqueId);
                current.id = 0;
                current.uniqueId = 0;
                current.completed = false;
                TransactionManager.this.pool.offer((Object)current);
                current = (Transaction)TransactionManager.this.cache[this.queueToClean].poll();
            }
            TransactionManager.this.cleanIndex = (TransactionManager.this.cleanIndex + 1) % 5;
            TransactionManager.this.scheduler.submitHeatbeat((Task)this);
            return 0L;
        }

        public int getQueueNumber() {
            TransactionManager.this.scheduler;
            return Scheduler.HEARTBEAT_QUEUE;
        }
    }
}

