/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx.cmd;

import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.controller.MgcpConnection;
import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.controller.NotifiedEntity;
import org.mobicents.media.server.mgcp.controller.naming.UnknownEndpointException;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.MgcpResponse;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.mgcp.tx.Action;
import org.mobicents.media.server.mgcp.tx.cmd.MgcpCommandException;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.scheduler.TaskChain;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.utils.Text;

public class AuditConnectionCmd
extends Action {
    private static final Logger logger = Logger.getLogger(AuditConnectionCmd.class);
    private static final Text ENDPOINT_ID_MISSING = new Text("Missing endpoint identifier");
    private static final Text ENDPOINT_INEXISTENT = new Text("Endpoint not available");
    private static final Text CONNECTION_ID_EXPECTED = new Text("Connection identifier was not specified");
    private static final Text CONNECTION_INEXISTENT = new Text("Connection not available");
    private static final Text SUCCESS = new Text("Success");
    private static final Text CONNECTION_NOT_READY = new Text("Connection not ready");
    private final Scheduler scheduler;
    private TaskChain handler;
    private Text localName = new Text("");
    private Text domainName = new Text("");
    private MgcpEndpoint[] endpoints = new MgcpEndpoint[1];
    private MgcpEndpoint endpoint;
    private MgcpRequest request;
    private Parameter connectionId;
    private Text[] endpointName = new Text[]{this.localName, this.domainName};
    private Parameter requestedInfo;
    private boolean queryCallId = false;
    private boolean queryNotifiedEntity = false;
    private boolean queryLocalConnectionOpts = false;
    private boolean queryMode = false;
    private boolean queryRemoteConnectionDes = false;
    private boolean queryLocalConnectionDes = false;
    private boolean queryConnectionParams = false;
    private int callId;
    private NotifiedEntity notifiedEntity;
    private MgcpConnection connection;
    private ConnectionMode connectionMode;
    private Text localConnectionOpts;
    private Text localConnectionDes;
    private Text remoteConnectionDes;
    private ConnectionParameters connectionParameters;
    private boolean connectionAvailable;

    public AuditConnectionCmd(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.handler = new TaskChain(2, this.scheduler);
        this.handler.add((Task)new Audit());
        this.handler.add((Task)new Respond());
        this.setActionHandler(this.handler);
        this.setRollbackHandler(new Rollback());
    }

    private class ConnectionParameters {
        private final String PACKETS_SENT = "PS";
        private final String PACKETS_RECEIVED = "PR";
        private final String PACKETS_LOST = "PL";
        private final String OCTETS_SENT = "OS";
        private final String OCTETS_RECEIVED = "OR";
        private final String JITTER = "JI";
        private final String LATENCY = "LA";
        int packetsSent = -1;
        int packetsReceived = -1;
        int packetsLost = -1;
        int octetsSent = -1;
        int octetsReceived = -1;
        int jitter = -1;
        int latency = -1;

        public Text toText() {
            StringBuilder builder = new StringBuilder();
            this.appendParameter("PS", this.packetsSent, builder);
            this.appendParameter("OS", this.octetsSent, builder);
            this.appendParameter("PR", this.packetsReceived, builder);
            this.appendParameter("OR", this.octetsReceived, builder);
            this.appendParameter("PL", this.packetsLost, builder);
            this.appendParameter("JI", this.jitter, builder);
            this.appendParameter("LA", this.latency, builder);
            int lastComma = builder.lastIndexOf(",");
            if (lastComma == builder.length() - 1) {
                builder.deleteCharAt(lastComma);
            }
            return new Text(builder.toString().trim());
        }

        private void appendParameter(String parameter, int value, StringBuilder builder) {
            if (value >= 0) {
                builder.append(" ").append(parameter).append("=").append(value);
            }
        }
    }

    private class Rollback
    extends Task {
        private Rollback() {
        }

        public int getQueueNumber() {
            return Scheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            int code = ((MgcpCommandException)AuditConnectionCmd.this.transaction().getLastError()).getCode();
            Text message = ((MgcpCommandException)AuditConnectionCmd.this.transaction().getLastError()).getErrorMessage();
            MgcpEvent evt = AuditConnectionCmd.this.transaction().getProvider().createEvent(2, AuditConnectionCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(code);
            response.setResponseString(message);
            response.setTxID(AuditConnectionCmd.this.transaction().getId());
            try {
                AuditConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Respond
    extends Task {
        private Respond() {
        }

        public int getQueueNumber() {
            return Scheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            MgcpEvent evt = AuditConnectionCmd.this.transaction().getProvider().createEvent(2, AuditConnectionCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            if (AuditConnectionCmd.this.connectionAvailable) {
                response.setResponseCode(200);
                response.setResponseString(SUCCESS);
            } else {
                response.setResponseCode(403);
                response.setResponseString(CONNECTION_NOT_READY);
            }
            response.setTxID(AuditConnectionCmd.this.transaction().getId());
            if (AuditConnectionCmd.this.requestedInfo != null) {
                if (AuditConnectionCmd.this.queryCallId) {
                    response.setParameter(Parameter.CALL_ID, new Text(AuditConnectionCmd.this.callId));
                }
                if (AuditConnectionCmd.this.queryNotifiedEntity) {
                    Text entity = new Text("");
                    if (AuditConnectionCmd.this.notifiedEntity != null) {
                        AuditConnectionCmd.this.notifiedEntity.getValue().copy(entity);
                        entity.trim();
                    }
                    response.setParameter(Parameter.NOTIFIED_ENTITY, entity);
                }
                if (AuditConnectionCmd.this.queryLocalConnectionOpts) {
                    response.setParameter(Parameter.LOCAL_CONNECTION_OPTIONS, AuditConnectionCmd.this.localConnectionOpts);
                }
                if (AuditConnectionCmd.this.queryMode) {
                    response.setParameter(Parameter.MODE, AuditConnectionCmd.this.connectionMode.getDescription());
                }
                if (AuditConnectionCmd.this.queryConnectionParams) {
                    response.setParameter(Parameter.CONNECTION_PARAMETERS, AuditConnectionCmd.this.connectionParameters.toText());
                }
                if (AuditConnectionCmd.this.queryLocalConnectionDes) {
                    response.setParameter(Parameter.SDP, AuditConnectionCmd.this.localConnectionDes);
                }
                if (AuditConnectionCmd.this.queryRemoteConnectionDes) {
                    // empty if block
                }
            }
            try {
                AuditConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Audit
    extends Task {
        private Audit() {
        }

        public int getQueueNumber() {
            return Scheduler.MANAGEMENT_QUEUE;
        }

        public long perform() {
            AuditConnectionCmd.this.request = (MgcpRequest)AuditConnectionCmd.this.getEvent().getMessage();
            AuditConnectionCmd.this.connectionId = AuditConnectionCmd.this.request.getParameter(Parameter.CONNECTION_ID);
            AuditConnectionCmd.this.requestedInfo = AuditConnectionCmd.this.request.getParameter(Parameter.REQUESTED_INFO);
            if (AuditConnectionCmd.this.request.getEndpoint() == null || AuditConnectionCmd.this.request.getEndpoint().length() == 0) {
                throw new MgcpCommandException(510, ENDPOINT_ID_MISSING);
            }
            AuditConnectionCmd.this.request.getEndpoint().divide('@', AuditConnectionCmd.this.endpointName);
            if (AuditConnectionCmd.this.connectionId == null) {
                throw new MgcpCommandException(510, CONNECTION_ID_EXPECTED);
            }
            this.findMgcpEndpoints(AuditConnectionCmd.this.localName, AuditConnectionCmd.this.endpoints);
            AuditConnectionCmd.this.endpoint = AuditConnectionCmd.this.endpoints[0];
            AuditConnectionCmd.this.connection = AuditConnectionCmd.this.endpoint.getConnection(AuditConnectionCmd.this.connectionId.getValue().hexToInteger());
            if (AuditConnectionCmd.this.connection == null) {
                throw new MgcpCommandException(515, CONNECTION_INEXISTENT);
            }
            AuditConnectionCmd.this.connectionAvailable = AuditConnectionCmd.this.connection.getConnection().isAvailable();
            if (AuditConnectionCmd.this.requestedInfo != null) {
                Collection requestedParams = AuditConnectionCmd.this.requestedInfo.getValue().split(',');
                this.auditRequestedInfo(requestedParams, AuditConnectionCmd.this.connection);
            }
            return 0L;
        }

        private int findMgcpEndpoints(Text localName, MgcpEndpoint[] endpoints) {
            try {
                int n = AuditConnectionCmd.this.transaction().find(localName, endpoints);
                if (n == 0) {
                    throw new MgcpCommandException(410, ENDPOINT_INEXISTENT);
                }
                return n;
            }
            catch (UnknownEndpointException e) {
                throw new MgcpCommandException(500, ENDPOINT_INEXISTENT);
            }
        }

        private void auditRequestedInfo(Collection<Text> requestedParams, MgcpConnection connection) {
            for (Text param : requestedParams) {
                if (param.equals((Object)Parameter.CALL_ID)) {
                    AuditConnectionCmd.this.queryCallId = true;
                    AuditConnectionCmd.this.callId = connection.getCallId();
                    continue;
                }
                if (param.equals((Object)Parameter.NOTIFIED_ENTITY)) {
                    AuditConnectionCmd.this.queryNotifiedEntity = true;
                    AuditConnectionCmd.this.notifiedEntity = AuditConnectionCmd.this.endpoint.getRequest().getCallAgent();
                    continue;
                }
                if (param.equals((Object)Parameter.LOCAL_CONNECTION_OPTIONS)) {
                    AuditConnectionCmd.this.queryLocalConnectionOpts = true;
                    AuditConnectionCmd.this.localConnectionOpts = new Text("");
                    continue;
                }
                if (param.equals((Object)Parameter.MODE)) {
                    AuditConnectionCmd.this.queryMode = true;
                    AuditConnectionCmd.this.connectionMode = connection.getConnection().getMode();
                    continue;
                }
                if (param.equals((Object)Parameter.REMOTE_CONNECTION_DESCRIPTION)) {
                    AuditConnectionCmd.this.queryRemoteConnectionDes = true;
                    String remoteSdp = connection.getConnection().getRemoteDescriptor();
                    AuditConnectionCmd.this.remoteConnectionDes = remoteSdp == null ? new Text("v=0") : new Text(remoteSdp);
                    continue;
                }
                if (param.equals((Object)Parameter.LOCAL_CONNECTION_DESCRIPTION)) {
                    AuditConnectionCmd.this.queryLocalConnectionDes = true;
                    String localSdp = connection.getConnection().getLocalDescriptor();
                    AuditConnectionCmd.this.localConnectionDes = localSdp == null ? new Text("v=0") : new Text(localSdp);
                    continue;
                }
                if (!param.equals((Object)Parameter.CONNECTION_PARAMETERS)) continue;
                AuditConnectionCmd.this.queryConnectionParams = true;
                this.auditConnectionParameters(connection);
            }
        }

        private void auditConnectionParameters(MgcpConnection connection) {
            AuditConnectionCmd.this.connectionParameters = new ConnectionParameters();
            ((AuditConnectionCmd)AuditConnectionCmd.this).connectionParameters.packetsSent = connection.getPacketsTransmitted();
            ((AuditConnectionCmd)AuditConnectionCmd.this).connectionParameters.packetsReceived = connection.getPacketsReceived();
            ((AuditConnectionCmd)AuditConnectionCmd.this).connectionParameters.jitter = (int)connection.getConnection().getJitter();
        }
    }
}

