/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.network.ProtocolHandler;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.MgcpListener;
import org.mobicents.media.server.mgcp.message.MgcpMessage;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.MgcpResponse;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;

public class MgcpProvider {
    private String name;
    private Listeners<MgcpListener> listeners = new Listeners();
    private final UdpManager transport;
    private DatagramChannel channel;
    private final int port;
    private final ConcurrentLinkedQueue<ByteBuffer> txBuffer = new ConcurrentLinkedQueue();
    private final ByteBuffer rxBuffer = ByteBuffer.allocate(8192);
    private final ConcurrentLinkedQueue<MgcpEventImpl> events = new ConcurrentLinkedQueue();
    private static final Logger logger = Logger.getLogger(MgcpProvider.class);

    public MgcpProvider(UdpManager transport, int port) {
        this("", transport, port);
    }

    protected MgcpProvider(String name, UdpManager transport, int port) {
        int i;
        this.name = name;
        this.transport = transport;
        this.port = port;
        for (i = 0; i < 100; ++i) {
            this.events.offer(new MgcpEventImpl(this));
        }
        for (i = 0; i < 100; ++i) {
            this.txBuffer.offer(ByteBuffer.allocate(8192));
        }
    }

    public MgcpEvent createEvent(int eventID, SocketAddress address) {
        MgcpEventImpl evt = this.events.poll();
        if (evt == null) {
            evt = new MgcpEventImpl(this);
        }
        evt.inQueue.set(false);
        evt.setEventID(eventID);
        evt.setAddress(address);
        return evt;
    }

    public void send(MgcpEvent event, SocketAddress destination) throws IOException {
        MgcpMessage msg = event.getMessage();
        ByteBuffer currBuffer = this.txBuffer.poll();
        if (currBuffer == null) {
            currBuffer = ByteBuffer.allocate(8192);
        }
        msg.write(currBuffer);
        this.channel.send(currBuffer, destination);
        currBuffer.clear();
        this.txBuffer.offer(currBuffer);
    }

    public void send(MgcpEvent event) throws IOException {
        MgcpMessage msg = event.getMessage();
        ByteBuffer currBuffer = this.txBuffer.poll();
        if (currBuffer == null) {
            currBuffer = ByteBuffer.allocate(8192);
        }
        msg.write(currBuffer);
        this.channel.send(currBuffer, event.getAddress());
        currBuffer.clear();
        this.txBuffer.offer(currBuffer);
    }

    public void send(MgcpMessage message, SocketAddress destination) throws IOException {
        ByteBuffer currBuffer = this.txBuffer.poll();
        if (currBuffer == null) {
            currBuffer = ByteBuffer.allocate(8192);
        }
        message.write(currBuffer);
        this.channel.send(currBuffer, destination);
        currBuffer.clear();
        this.txBuffer.offer(currBuffer);
    }

    public void addListener(MgcpListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(MgcpListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void activate() {
        try {
            logger.info((Object)"Opening channel");
            this.channel = this.transport.open((ProtocolHandler)new MGCPHandler());
        }
        catch (IOException e) {
            logger.info((Object)("Could not open UDP channel: " + e.getMessage()));
            return;
        }
        try {
            logger.info((Object)("Binding channel to " + this.transport.getLocalBindAddress() + ":" + this.port));
            this.transport.bindLocal(this.channel, this.port);
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not close MGCP Provider channel", (Throwable)e);
            }
            logger.info((Object)("Could not open UDP channel: " + e.getMessage()));
            return;
        }
    }

    public void shutdown() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                logger.error((Object)"Could not shutdown MGCP Provider", (Throwable)e);
            }
        }
    }

    private void recycleEvent(MgcpEventImpl event) {
        if (event.inQueue.getAndSet(true)) {
            logger.warn((Object)"====================== ALARM ALARM ALARM==============");
        } else {
            event.response.clean();
            event.request.clean();
            this.events.offer(event);
        }
    }

    private class MgcpEventImpl
    implements MgcpEvent {
        private MgcpProvider provider;
        private int eventID;
        private MgcpRequest request = new MgcpRequest();
        private MgcpResponse response = new MgcpResponse();
        private SocketAddress address;
        private AtomicBoolean inQueue = new AtomicBoolean(true);

        public MgcpEventImpl(MgcpProvider provider) {
            this.provider = provider;
        }

        public MgcpProvider getSource() {
            return this.provider;
        }

        @Override
        public MgcpMessage getMessage() {
            return this.eventID == 1 ? this.request : this.response;
        }

        @Override
        public int getEventID() {
            return this.eventID;
        }

        protected void setEventID(int eventID) {
            this.eventID = eventID;
        }

        @Override
        public void recycle() {
            MgcpProvider.this.recycleEvent(this);
        }

        @Override
        public SocketAddress getAddress() {
            return this.address;
        }

        protected void setAddress(SocketAddress address) {
            InetSocketAddress a = (InetSocketAddress)address;
            this.address = new InetSocketAddress(a.getHostName(), a.getPort());
        }
    }

    private class Receiver {
        private SocketAddress address;

        public long perform() {
            MgcpProvider.this.rxBuffer.clear();
            try {
                this.address = MgcpProvider.this.channel.receive(MgcpProvider.this.rxBuffer);
                if (this.address != null) {
                    MgcpProvider.this.rxBuffer.flip();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Receive  message " + MgcpProvider.this.rxBuffer.limit() + " bytes length"));
                    }
                    if (MgcpProvider.this.rxBuffer.limit() == 0) {
                        return 0L;
                    }
                    byte b = MgcpProvider.this.rxBuffer.get();
                    MgcpProvider.this.rxBuffer.rewind();
                    int msgType = -1;
                    msgType = b >= 48 && b <= 57 ? 2 : 1;
                    MgcpEvent evt = MgcpProvider.this.createEvent(msgType, this.address);
                    if (logger.isDebugEnabled()) {
                        byte[] data = MgcpProvider.this.rxBuffer.array();
                        logger.debug((Object)("Parsing message: " + new String(data, 0, MgcpProvider.this.rxBuffer.limit())));
                    }
                    MgcpMessage msg = evt.getMessage();
                    msg.read(MgcpProvider.this.rxBuffer);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Dispatching message");
                    }
                    MgcpProvider.this.listeners.dispatch((Event)evt);
                    MgcpProvider.this.rxBuffer.clear();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not process message", (Throwable)e);
            }
            return 0L;
        }
    }

    private class MGCPHandler
    implements ProtocolHandler {
        private Receiver receiver;

        private MGCPHandler() {
            this.receiver = new Receiver();
        }

        public void receive(DatagramChannel channel) {
            this.receiver.perform();
        }

        public void send(DatagramChannel channel) {
        }

        public boolean isReadable() {
            return false;
        }

        public boolean isWriteable() {
            return false;
        }

        public void setKey(SelectionKey key) {
        }

        public void onClosed() {
            MgcpProvider.this.shutdown();
            MgcpProvider.this.activate();
        }
    }
}

