/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx;

import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.controller.CallManager;
import org.mobicents.media.server.mgcp.controller.naming.NamingTree;
import org.mobicents.media.server.mgcp.tx.Transaction;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.scheduler.Scheduler;

public class TransactionManager {
    private static final Logger log = Logger.getLogger(TransactionManager.class);
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(1);
    private static final int CACHE_SIZE = 5;
    private final Clock clock;
    private final Scheduler scheduler;
    protected CallManager callManager;
    protected MgcpProvider provider;
    protected NamingTree namingService;
    private final ConcurrentCyclicFIFO<Transaction> transactionPool;
    private final ConcurrentMap<Transaction> activeTransactions;
    private ConcurrentCyclicFIFO<Transaction>[] cache = new ConcurrentCyclicFIFO[5];
    private final Heartbeat cacheHeartbeat;
    private ScheduledFuture<?> cacheHeartbeatFuture;
    private int cleanIndex = 0;

    public TransactionManager(Clock clock, Scheduler scheduler, int size) {
        int i;
        this.clock = clock;
        this.scheduler = scheduler;
        this.transactionPool = new ConcurrentCyclicFIFO();
        this.activeTransactions = new ConcurrentMap();
        for (i = 0; i < size; ++i) {
            this.transactionPool.offer((Object)new Transaction(this));
        }
        for (i = 0; i < 5; ++i) {
            this.cache[i] = new ConcurrentCyclicFIFO();
        }
        this.cacheHeartbeat = new Heartbeat();
    }

    public void start() {
        this.cacheHeartbeatFuture = this.scheduler.scheduleWithFixedDelay((Runnable)this.cacheHeartbeat, 20L, 20L, TimeUnit.MILLISECONDS);
    }

    public void setNamingService(NamingTree namingService) {
        this.namingService = namingService;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public long getTime() {
        return this.clock.getTime();
    }

    public void setCallManager(CallManager callManager) {
        this.callManager = callManager;
    }

    public void setMgcpProvider(MgcpProvider provider) {
        this.provider = provider;
    }

    public Transaction find(int id) {
        Transaction currTransaction = (Transaction)this.activeTransactions.get((Object)id);
        return currTransaction;
    }

    public Transaction findByTransactionNumber(int transactionNumber) {
        Iterator transactions = this.activeTransactions.valuesIterator();
        while (transactions.hasNext()) {
            Transaction transaction = (Transaction)transactions.next();
            if (transaction.getId() != transactionNumber) continue;
            return transaction;
        }
        return null;
    }

    public Transaction allocateNew(int id) {
        Transaction t = this.begin(ID_GENERATOR.getAndIncrement());
        if (t != null) {
            t.id = id;
        }
        return t;
    }

    private Transaction begin(int id) {
        Transaction t = (Transaction)this.transactionPool.poll();
        if (t == null) {
            t = new Transaction(this);
        }
        t.uniqueId = id;
        this.activeTransactions.put((Object)t.uniqueId, (Object)t);
        return t;
    }

    protected void terminate(Transaction t) {
        this.cache[this.cleanIndex].offer((Object)t);
    }

    protected int nextID() {
        return ID_GENERATOR.incrementAndGet();
    }

    protected int remainder() {
        return this.transactionPool.size();
    }

    private class Heartbeat
    implements Runnable {
        private int queueToClean;

        @Override
        public void run() {
            this.queueToClean = (TransactionManager.this.cleanIndex + 1) % 5;
            Transaction current = (Transaction)TransactionManager.this.cache[this.queueToClean].poll();
            while (current != null) {
                TransactionManager.this.activeTransactions.remove((Object)current.uniqueId);
                current.id = 0;
                current.uniqueId = 0;
                current.completed = false;
                TransactionManager.this.transactionPool.offer((Object)current);
                current = (Transaction)TransactionManager.this.cache[this.queueToClean].poll();
            }
            TransactionManager.this.cleanIndex = (TransactionManager.this.cleanIndex + 1) % 5;
        }
    }
}

