/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx.cmd;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.controller.MgcpCall;
import org.mobicents.media.server.mgcp.controller.MgcpConnection;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.MgcpResponse;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.mgcp.params.LocalConnectionOptions;
import org.mobicents.media.server.mgcp.tx.Action;
import org.mobicents.media.server.mgcp.tx.cmd.MgcpCommandException;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.scheduler.TaskChain;
import org.mobicents.media.server.spi.ModeNotSupportedException;
import org.mobicents.media.server.utils.Text;

public class ModifyConnectionCmd
extends Action {
    private static final Text CALLID_MISSING = new Text("Missing call identifier");
    private static final Text UNKNOWN_CALL_IDENTIFIER = new Text("Could not find this call with specified identifier");
    private static final Text CONNECTIONID_EXPECTED = new Text("Connection identifier was not specified");
    private static final Text SDP_NEGOTIATION_FAILED = new Text("SDP_NEGOTIATION_FAILED");
    private static final Text SUCCESS = new Text("Success");
    private MgcpRequest request;
    private Parameter connectionID;
    private TaskChain handler;
    private int code;
    private Text message;
    private MgcpConnection mgcpConnection = null;
    private LocalConnectionOptions lcOptions = new LocalConnectionOptions();
    private static final Logger logger = Logger.getLogger(ModifyConnectionCmd.class);

    public ModifyConnectionCmd(Scheduler scheduler) {
        this.handler = new TaskChain(1, scheduler);
        Modifier modifier = new Modifier();
        this.handler.add((Task)modifier);
        ErrorHandler errorHandler = new ErrorHandler();
        this.setActionHandler(this.handler);
        this.setRollbackHandler(errorHandler);
    }

    private class ErrorHandler
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            ModifyConnectionCmd.this.code = ((MgcpCommandException)ModifyConnectionCmd.this.transaction().getLastError()).getCode();
            ModifyConnectionCmd.this.message = ((MgcpCommandException)ModifyConnectionCmd.this.transaction().getLastError()).getErrorMessage();
            MgcpEvent evt = ModifyConnectionCmd.this.transaction().getProvider().createEvent(2, ModifyConnectionCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(ModifyConnectionCmd.this.code);
            response.setResponseString(ModifyConnectionCmd.this.message);
            response.setTxID(ModifyConnectionCmd.this.transaction().getId());
            if (ModifyConnectionCmd.this.connectionID != null) {
                response.setParameter(Parameter.CONNECTION_ID, ModifyConnectionCmd.this.connectionID.getValue());
            }
            try {
                ModifyConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Modifier
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            Text descriptor;
            ModifyConnectionCmd.this.request = (MgcpRequest)ModifyConnectionCmd.this.getEvent().getMessage();
            Parameter callID = ModifyConnectionCmd.this.request.getParameter(Parameter.CALL_ID);
            if (callID == null) {
                throw new MgcpCommandException(510, CALLID_MISSING);
            }
            Parameter l = ModifyConnectionCmd.this.request.getParameter(Parameter.LOCAL_CONNECTION_OPTIONS);
            if (l != null) {
                ModifyConnectionCmd.this.lcOptions.setValue(l.getValue());
            } else {
                ModifyConnectionCmd.this.lcOptions.setValue(null);
            }
            MgcpCall call = ModifyConnectionCmd.this.transaction().getCall(callID.getValue().hexToInteger(), false);
            if (call == null) {
                throw new MgcpCommandException(516, UNKNOWN_CALL_IDENTIFIER);
            }
            ModifyConnectionCmd.this.connectionID = ModifyConnectionCmd.this.request.getParameter(Parameter.CONNECTION_ID);
            if (ModifyConnectionCmd.this.connectionID == null) {
                throw new MgcpCommandException(510, CONNECTIONID_EXPECTED);
            }
            try {
                ModifyConnectionCmd.this.mgcpConnection = call.getMgcpConnection(ModifyConnectionCmd.this.connectionID.getValue().hexToInteger());
            }
            catch (Exception e) {
                throw new MgcpCommandException(250, new Text("Unknown connectionidentifier, probably it was deleted"));
            }
            if (ModifyConnectionCmd.this.mgcpConnection == null) {
                throw new MgcpCommandException(250, new Text("Unknown connectionidentifier, probably it was deleted"));
            }
            Parameter sdp = ModifyConnectionCmd.this.request.getParameter(Parameter.SDP);
            Parameter mode = ModifyConnectionCmd.this.request.getParameter(Parameter.MODE);
            if (sdp != null) {
                try {
                    ModifyConnectionCmd.this.mgcpConnection.setOtherParty(sdp.getValue());
                }
                catch (IOException e) {
                    logger.error((Object)"Could not set remote peer", (Throwable)e);
                    throw new MgcpCommandException(505, SDP_NEGOTIATION_FAILED);
                }
            }
            if (mode != null) {
                try {
                    ModifyConnectionCmd.this.mgcpConnection.setMode(mode.getValue());
                }
                catch (ModeNotSupportedException e) {
                    throw new MgcpCommandException(517, new Text("problem with mode"));
                }
            }
            ModifyConnectionCmd.this.mgcpConnection.setDtmfClamp(ModifyConnectionCmd.this.lcOptions.getDtmfClamp());
            MgcpEvent evt = ModifyConnectionCmd.this.transaction().getProvider().createEvent(2, ModifyConnectionCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(200);
            response.setResponseString(SUCCESS);
            response.setTxID(ModifyConnectionCmd.this.transaction().getId());
            if (ModifyConnectionCmd.this.connectionID != null) {
                response.setParameter(Parameter.CONNECTION_ID, ModifyConnectionCmd.this.connectionID.getValue());
            }
            if ((descriptor = ModifyConnectionCmd.this.mgcpConnection.getDescriptor()) != null) {
                response.setParameter(Parameter.SDP, ModifyConnectionCmd.this.mgcpConnection.getDescriptor());
            }
            try {
                ModifyConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }
}

