/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.MgcpListener;
import org.mobicents.media.server.mgcp.MgcpProvider;
import org.mobicents.media.server.mgcp.controller.MgcpCall;
import org.mobicents.media.server.mgcp.controller.MgcpConnection;
import org.mobicents.media.server.mgcp.controller.MgcpEndpointStateListener;
import org.mobicents.media.server.mgcp.controller.Request;
import org.mobicents.media.server.mgcp.controller.signal.MgcpPackage;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.TooManyConnectionsException;
import org.mobicents.media.server.utils.Text;

public class MgcpEndpoint {
    public static AtomicInteger txID = new AtomicInteger(1);
    private static final int N = 15;
    public static final int STATE_LOCKED = 1;
    public static final int STATE_FREE = 2;
    public static final int STATE_BUSY = 3;
    private Endpoint endpoint;
    protected Text fullName;
    private AtomicInteger state = new AtomicInteger(2);
    Request request;
    private ConcurrentCyclicFIFO<MgcpConnection> connections = new ConcurrentCyclicFIFO();
    private ConcurrentMap<MgcpConnection> activeConnections = new ConcurrentMap();
    private Iterator<Integer> keyIterator;
    protected MgcpProvider mgcpProvider;
    private MgcpListener listener;
    private MgcpEndpointStateListener stateListener;

    public MgcpEndpoint(Endpoint endpoint, MgcpProvider mgcpProvider, String domainName, int port, Collection<MgcpPackage> packages) {
        this.endpoint = endpoint;
        this.mgcpProvider = mgcpProvider;
        this.fullName = new Text(endpoint.getLocalName() + "@" + domainName + ":" + port);
        this.request = new Request(this, packages);
        for (int i = 0; i < 15; ++i) {
            this.connections.offer((Object)new MgcpConnection());
        }
    }

    public String getName() {
        return this.endpoint.getLocalName();
    }

    public Text getFullName() {
        return this.fullName;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setMgcpListener(MgcpListener listener) {
        this.listener = listener;
    }

    public void setMgcpEndpointStateListener(MgcpEndpointStateListener listener) {
        this.stateListener = listener;
    }

    public int getState() {
        return this.state.get();
    }

    public Request getRequest() {
        return this.request;
    }

    public void lock() {
        this.state.set(1);
    }

    public void share() {
        if (this.state.get() == 1) {
            this.state.set(2);
            if (this.stateListener != null) {
                this.stateListener.onFreed(this);
            }
        }
    }

    public MgcpConnection createConnection(MgcpCall call, ConnectionType type, boolean isLocal) throws TooManyConnectionsException, ResourceUnavailableException {
        Connection connection = this.endpoint.createConnection(type, Boolean.valueOf(isLocal));
        MgcpConnection mgcpConnection = (MgcpConnection)this.connections.poll();
        if (mgcpConnection == null) {
            mgcpConnection = new MgcpConnection();
        }
        mgcpConnection.wrap(this, call, connection);
        this.activeConnections.put((Object)mgcpConnection.id, (Object)mgcpConnection);
        this.state.set(3);
        return mgcpConnection;
    }

    public void deleteConnection(Integer id) {
        int oldValue;
        MgcpConnection mgcpConnection = (MgcpConnection)this.activeConnections.remove((Object)id);
        if (mgcpConnection == null) {
            return;
        }
        mgcpConnection.release();
        this.endpoint.deleteConnection(mgcpConnection.connection);
        this.connections.offer((Object)mgcpConnection);
        if (this.activeConnections.isEmpty() && (oldValue = this.state.getAndSet(2)) != 2 && this.stateListener != null) {
            this.stateListener.onFreed(this);
        }
        this.request.cancel();
    }

    public void deleteAllConnections() {
        this.keyIterator = this.activeConnections.keysIterator();
        while (this.keyIterator.hasNext()) {
            this.connections.offer(this.activeConnections.remove((Object)this.keyIterator.next()));
        }
        this.endpoint.deleteAllConnections();
        int oldValue = this.state.getAndSet(2);
        if (oldValue != 2 && this.stateListener != null) {
            this.stateListener.onFreed(this);
        }
        this.request.cancel();
    }

    public MgcpConnection getConnection(Integer connectionID) {
        return (MgcpConnection)this.activeConnections.get((Object)connectionID);
    }

    protected void send(MgcpEvent message, SocketAddress address) {
        this.listener.process(message);
    }

    protected MgcpConnection poll(MgcpCall call) {
        MgcpConnection mgcpConnection = (MgcpConnection)this.connections.poll();
        if (mgcpConnection == null) {
            mgcpConnection = new MgcpConnection();
        }
        this.activeConnections.put((Object)mgcpConnection.id, (Object)mgcpConnection);
        mgcpConnection.setCall(call);
        return mgcpConnection;
    }

    protected void offer(MgcpConnection mgcpConnection) {
        int oldValue;
        this.activeConnections.remove((Object)mgcpConnection.id);
        mgcpConnection.release();
        this.endpoint.deleteConnection(mgcpConnection.connection);
        this.connections.offer((Object)mgcpConnection);
        if (this.activeConnections.isEmpty() && (oldValue = this.state.getAndSet(2)) != 2 && this.stateListener != null) {
            this.stateListener.onFreed(this);
        }
    }

    public void configure(boolean isALaw) {
        this.endpoint.configure(isALaw);
    }
}

