/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx.cmd;

import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.mgcp.tx.Action;
import org.mobicents.media.server.mgcp.tx.cmd.AuditConnectionCmd;
import org.mobicents.media.server.mgcp.tx.cmd.CreateConnectionCmd;
import org.mobicents.media.server.mgcp.tx.cmd.DeleteConnectionCmd;
import org.mobicents.media.server.mgcp.tx.cmd.EndpointConfigurationCmd;
import org.mobicents.media.server.mgcp.tx.cmd.ModifyConnectionCmd;
import org.mobicents.media.server.mgcp.tx.cmd.NotificationRequestCmd;
import org.mobicents.media.server.mgcp.tx.cmd.NotifyCmd;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.utils.Text;

public class ActionSelector {
    private static final Text AUDIT_CONNECTION = new Text("AUCX");
    private static final Text CREATE_CONNECTION = new Text("CRCX");
    private static final Text MODIFY_CONNECTION = new Text("MDCX");
    private static final Text DELETE_CONNECTION = new Text("DLCX");
    private static final Text REQUEST_NOTIFICATION = new Text("RQNT");
    private static final Text REQUEST_NOTIFY = new Text("NTFY");
    private static final Text ENDPOINT_CONFIGURATION = new Text("EPCF");
    private Text command;
    private MgcpRequest request;
    private AuditConnectionCmd aucx;
    private CreateConnectionCmd crcx;
    private ModifyConnectionCmd mdcx;
    private DeleteConnectionCmd dlcx;
    private NotificationRequestCmd rqnt;
    private EndpointConfigurationCmd epcf;
    private NotifyCmd ntfy;

    public ActionSelector(Scheduler scheduler) {
        this.aucx = new AuditConnectionCmd(scheduler);
        this.crcx = new CreateConnectionCmd(scheduler);
        this.mdcx = new ModifyConnectionCmd(scheduler);
        this.dlcx = new DeleteConnectionCmd(scheduler);
        this.rqnt = new NotificationRequestCmd(scheduler);
        this.ntfy = new NotifyCmd(scheduler);
        this.epcf = new EndpointConfigurationCmd(scheduler);
    }

    public Action getAction(MgcpEvent event) {
        switch (event.getEventID()) {
            case 1: {
                this.request = (MgcpRequest)event.getMessage();
                this.command = this.request.getCommand();
                if (this.command.equals((Object)CREATE_CONNECTION)) {
                    return this.crcx;
                }
                if (this.command.equals((Object)MODIFY_CONNECTION)) {
                    return this.mdcx;
                }
                if (this.command.equals((Object)ENDPOINT_CONFIGURATION)) {
                    return this.epcf;
                }
                if (this.command.equals((Object)DELETE_CONNECTION)) {
                    if (this.request.getParameter(Parameter.REASON_CODE) != null) {
                        return this.ntfy;
                    }
                    return this.dlcx;
                }
                if (this.command.equals((Object)REQUEST_NOTIFICATION)) {
                    return this.rqnt;
                }
                if (this.command.equals((Object)REQUEST_NOTIFY)) {
                    return this.ntfy;
                }
                if (!this.command.equals((Object)AUDIT_CONNECTION)) break;
                return this.aucx;
            }
        }
        return null;
    }
}

