/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.connection;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.mgcp.connection.ConnectionEventImpl;
import org.mobicents.media.server.scheduler.PriorityQueueScheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionEvent;
import org.mobicents.media.server.spi.ConnectionFailureListener;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.ModeNotSupportedException;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.utils.Text;

public abstract class BaseConnection
implements Connection {
    private int id;
    private String textualId;
    private PriorityQueueScheduler scheduler;
    private volatile ConnectionState state = ConnectionState.NULL;
    private final Object stateMonitor = new Integer(0);
    private Listeners<ConnectionListener> listeners = new Listeners();
    private ConnectionEvent stateEvent;
    private volatile long ttl;
    private HeartBeat heartBeat;
    private Endpoint activeEndpoint;
    private ConnectionMode connectionMode = ConnectionMode.INACTIVE;
    private static final Logger logger = Logger.getLogger(BaseConnection.class);

    public BaseConnection(int id, PriorityQueueScheduler scheduler) {
        this.id = id;
        this.textualId = Integer.toHexString(id);
        this.scheduler = scheduler;
        this.heartBeat = new HeartBeat();
        this.stateEvent = new ConnectionEventImpl(1, this);
    }

    public abstract AudioComponent getAudioComponent();

    public abstract OOBComponent getOOBComponent();

    public int getId() {
        return this.id;
    }

    public String getTextualId() {
        return this.textualId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionState getState() {
        Object object = this.stateMonitor;
        synchronized (object) {
            return this.state;
        }
    }

    private void setState(ConnectionState state) {
        this.state = state;
        this.ttl = state.getTimeout() * 10L + 1L;
        switch (state) {
            case HALF_OPEN: {
                this.scheduler.submitHeatbeat((Task)this.heartBeat);
                break;
            }
            case NULL: {
                this.heartBeat.cancel();
                break;
            }
        }
        try {
            this.listeners.dispatch((Event)this.stateEvent);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getDescriptor() {
        return null;
    }

    public String getLocalDescriptor() {
        return null;
    }

    public String getRemoteDescriptor() {
        return null;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.activeEndpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.activeEndpoint;
    }

    public void addListener(ConnectionListener listener) {
        try {
            this.listeners.add((Listener)listener);
        }
        catch (TooManyListenersException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void removeListener(ConnectionListener listener) {
        this.listeners.remove((Listener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws Exception {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state != ConnectionState.NULL) {
                throw new IllegalStateException("Connection already bound");
            }
            this.onCreated();
            this.setState(ConnectionState.HALF_OPEN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws Exception {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state == ConnectionState.NULL) {
                throw new IllegalStateException("Connection not bound yet");
            }
            if (this.state == ConnectionState.OPEN) {
                throw new IllegalStateException("Connection opened already");
            }
            this.onOpened();
            this.setState(ConnectionState.OPEN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state != ConnectionState.NULL) {
                this.onClosed();
                this.setState(ConnectionState.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail() {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state != ConnectionState.NULL) {
                this.onFailed();
                this.setState(ConnectionState.NULL);
            }
        }
    }

    public ConnectionMode getMode() {
        return this.connectionMode;
    }

    public void setMode(ConnectionMode mode) throws ModeNotSupportedException {
        if (this.activeEndpoint != null) {
            this.activeEndpoint.modeUpdated(this.connectionMode, mode);
        }
        this.connectionMode = mode;
    }

    public abstract void setConnectionFailureListener(ConnectionFailureListener var1);

    protected abstract void onCreated() throws Exception;

    protected abstract void onOpened() throws Exception;

    protected abstract void onClosed();

    protected abstract void onFailed();

    public abstract void setOtherParty(Connection var1) throws IOException;

    public abstract void setOtherParty(byte[] var1) throws IOException;

    public abstract void setOtherParty(Text var1) throws IOException;

    public boolean getIsLocal() {
        return false;
    }

    public void setIsLocal(boolean isLocal) {
    }

    protected void releaseConnection(ConnectionType connectionType) {
        if (this.activeEndpoint != null) {
            this.activeEndpoint.deleteConnection((Connection)this, connectionType);
        }
        this.activeEndpoint = null;
    }

    private class HeartBeat
    extends Task {
        public int getQueueNumber() {
            return PriorityQueueScheduler.HEARTBEAT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            Object object = BaseConnection.this.stateMonitor;
            synchronized (object) {
                BaseConnection.this.ttl--;
                if (BaseConnection.this.ttl == 0L) {
                    BaseConnection.this.fail();
                } else {
                    BaseConnection.this.scheduler.submitHeatbeat((Task)this);
                }
            }
            return 0L;
        }
    }
}

