/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.endpoint;

import org.mobicents.media.Component;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.mgcp.endpoint.BaseMixerEndpointImpl;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;

public class IvrEndpoint
extends BaseMixerEndpointImpl {
    public IvrEndpoint(String localName) {
        super(localName);
    }

    @Override
    public Connection createConnection(ConnectionType type, Boolean isLocal) throws ResourceUnavailableException {
        Connection connection = super.createConnection(type, isLocal);
        if (this.getActiveConnectionsCount() == 1) {
            this.mediaGroup.getDtmfDetector().activate();
        }
        return connection;
    }

    @Override
    public void start() throws ResourceUnavailableException {
        super.start();
        this.audioMixer.addComponent(this.mediaGroup.getAudioComponent());
        this.oobMixer.addComponent(this.mediaGroup.getOOBComponent());
    }

    @Override
    public void stop() {
        this.audioMixer.release(this.mediaGroup.getAudioComponent());
        this.oobMixer.release(this.mediaGroup.getOOBComponent());
        super.stop();
    }

    @Override
    public Component getResource(MediaType mediaType, ComponentType componentType) {
        switch (mediaType) {
            case AUDIO: {
                switch (componentType) {
                    case PLAYER: {
                        return this.mediaGroup.getPlayer();
                    }
                    case RECORDER: {
                        return this.mediaGroup.getRecorder();
                    }
                    case DTMF_DETECTOR: {
                        return this.mediaGroup.getDtmfDetector();
                    }
                    case DTMF_GENERATOR: {
                        return this.mediaGroup.getDtmfGenerator();
                    }
                }
                break;
            }
        }
        return null;
    }
}

