/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.endpoint.factory;

import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.server.mgcp.endpoint.factory.EndpointFactory;
import org.mobicents.media.server.mgcp.endpoint.naming.EndpointNameGenerator;
import org.mobicents.media.server.spi.Endpoint;

public abstract class AbstractEndpointFactory<T extends Endpoint>
implements EndpointFactory<T> {
    protected final EndpointNameGenerator nameParser;
    protected final AtomicInteger idGenerator = new AtomicInteger(1);
    protected final String endpointPattern;
    protected final int initialSize;

    public AbstractEndpointFactory(String endpointPattern, int initialSize) {
        this.endpointPattern = endpointPattern;
        this.initialSize = initialSize;
        this.nameParser = new EndpointNameGenerator();
        this.nameParser.setPattern(endpointPattern);
    }

    public AbstractEndpointFactory(String endpointPattern) {
        this(endpointPattern, 0);
    }

    public String getEndpointPattern() {
        return this.endpointPattern;
    }

    protected String generateName() {
        return this.endpointPattern + this.idGenerator.getAndIncrement();
    }
}

