/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.endpoint.naming;

import org.mobicents.media.server.mgcp.endpoint.BaseEndpointImpl;
import org.mobicents.media.server.mgcp.endpoint.exception.UnknownEndpointException;
import org.mobicents.media.server.mgcp.endpoint.naming.EndpointName;
import org.mobicents.media.server.mgcp.endpoint.naming.Node;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointState;
import org.mobicents.media.server.spi.ResourceUnavailableException;

public class NamingService {
    private Node root = new Node(new String[]{""}, 0);
    private final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Endpoint endpoint) {
        Object object = this.LOCK;
        synchronized (object) {
            EndpointName name = new EndpointName(endpoint.getLocalName());
            Node node = this.getNode(name.getCategory(), true);
            node.queue.add(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Endpoint endpoint) {
        Object object = this.LOCK;
        synchronized (object) {
            EndpointName name = new EndpointName(endpoint.getLocalName());
            Node node = this.getNode(name.getCategory(), true);
            node.queue.remove(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint lookup(String name, boolean exclusive) throws ResourceUnavailableException, UnknownEndpointException {
        Object object = this.LOCK;
        synchronized (object) {
            EndpointName endpointName = new EndpointName(name);
            Node node = this.getNode(endpointName.getCategory(), false);
            if (node == null) {
                return null;
            }
            return node.lookup(endpointName.getID(), exclusive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void share(Endpoint endpoint) {
        Object object = this.LOCK;
        synchronized (object) {
            ((BaseEndpointImpl)endpoint).setState(EndpointState.READY);
        }
    }

    private Node getNode(String fqn1, boolean allowNew) {
        String[] fqn = fqn1.split("/");
        return this.root.getNode(fqn, 1, allowNew);
    }
}

