/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.endpoint.naming;

import java.util.ArrayList;
import org.mobicents.media.server.mgcp.endpoint.exception.UnknownEndpointException;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointState;
import org.mobicents.media.server.spi.ResourceUnavailableException;

class Node {
    private String name;
    private ArrayList<Node> childs = new ArrayList();
    protected ArrayList<Endpoint> queue = new ArrayList();

    protected Node(String[] fqn, int k) {
        this.name = fqn[k];
    }

    protected Node getNode(String[] fqn, int k, boolean allowNew) {
        if (k == fqn.length) {
            return this;
        }
        for (int i = 0; i < this.childs.size(); ++i) {
            if (!this.childs.get((int)i).name.equals(fqn[k])) continue;
            if (k == fqn.length - 1) {
                return this.childs.get(i);
            }
            return this.childs.get(i).getNode(fqn, k + 1, allowNew);
        }
        if (allowNew) {
            Node node = new Node(fqn, k);
            this.childs.add(node);
            return node.getNode(fqn, k + 1, allowNew);
        }
        return null;
    }

    protected Endpoint lookup(String id, boolean exclusive) throws ResourceUnavailableException, UnknownEndpointException {
        return id.equals("$") ? this.lookupAny(exclusive) : this.lookupConcrete(id);
    }

    private Endpoint lookupConcrete(String id) throws UnknownEndpointException {
        for (int i = 0; i < this.queue.size(); ++i) {
            if (!this.queue.get(i).getLocalName().endsWith(id)) continue;
            return this.queue.get(i);
        }
        throw new UnknownEndpointException();
    }

    private Endpoint lookupAny(boolean exclusive) throws ResourceUnavailableException {
        for (int i = 0; i < this.queue.size(); ++i) {
            if (this.queue.get(i).getState() != EndpointState.READY) continue;
            Endpoint endpoint = this.queue.remove(i);
            this.queue.add(endpoint);
            return endpoint;
        }
        throw new ResourceUnavailableException();
    }
}

