/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.params;

import java.util.Collection;
import org.mobicents.media.server.utils.Text;

public class LocalConnectionOptions {
    public static final Text CODECS = new Text("a");
    public static final Text BANDWIDTH = new Text("b");
    public static final Text PACKETIZATION_PERIOD = new Text("p");
    public static final Text TYPE_OF_NETWORK = new Text("nt");
    public static final Text TYPE_OF_SERVICE = new Text("t");
    public static final Text ECHO_CANCELATION = new Text("e");
    public static final Text GAIN_CONTROL = new Text("gc");
    public static final Text SILENCE_SUPPRESSION = new Text("s");
    public static final Text RESOURCE_RESERVATION = new Text("r");
    public static final Text ENCRYPTION_KEY = new Text("k");
    public static final Text DTMF_CLAMP = new Text("x-dc");
    public static final Text WEBRTC = new Text("webrtc");
    public static final Text LOCAL_NETWORK = new Text("LOCAL");
    public static final Text TRUE = new Text("true");
    private Text codecs = new Text();
    private Text gain = new Text();
    private Text bandwidth = new Text();
    private Text packetizationPeriod = new Text();
    private Text typeOfService = new Text();
    private Text echoCancelation = new Text();
    private Text silenceSuppression = new Text();
    private Text resourceReservation = new Text();
    private Text encryptionKey = new Text();
    private Text dtmfclamp = new Text();
    private Text webrtc = new Text();
    private Text keyword = new Text();
    private Text value = new Text();
    private Text[] option = new Text[]{this.keyword, this.value};
    private boolean isValid = false;
    private boolean isLocal = false;

    public void setValue(Text text) {
        this.isLocal = false;
        if (text == null) {
            this.isValid = false;
            return;
        }
        this.isValid = true;
        Collection tokens = text.split(',');
        for (Text token : tokens) {
            int count = token.divide(':', this.option);
            if (count != 2) continue;
            if (this.keyword.length() == 1) {
                switch (this.keyword.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        this.value.copy(this.bandwidth);
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        this.value.copy(this.packetizationPeriod);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        this.value.copy(this.typeOfService);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        this.value.copy(this.echoCancelation);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        this.value.copy(this.silenceSuppression);
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        this.value.copy(this.resourceReservation);
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        this.value.copy(this.encryptionKey);
                        break;
                    }
                    case 'x': {
                        if (!this.keyword.equals((Object)DTMF_CLAMP)) break;
                        this.value.copy(this.dtmfclamp);
                    }
                }
                continue;
            }
            if (this.keyword.length() == 2) {
                switch (this.keyword.charAt(0)) {
                    case 'G': 
                    case 'g': {
                        if (this.keyword.charAt(1) != 'c' && this.keyword.charAt(1) != 'C') break;
                        this.value.copy(this.gain);
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        if (this.keyword.charAt(1) != 't' && this.keyword.charAt(1) != 'T' || !this.value.equals((Object)LOCAL_NETWORK)) break;
                        this.isLocal = true;
                    }
                }
                continue;
            }
            if (this.keyword.equals((Object)DTMF_CLAMP)) {
                this.value.copy(this.dtmfclamp);
                continue;
            }
            if (!this.keyword.equals((Object)WEBRTC)) continue;
            this.value.copy(this.webrtc);
        }
    }

    public int getGain() {
        return this.isValid ? this.gain.toInteger() : 0;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public boolean getDtmfClamp() {
        if (!this.isValid) {
            return false;
        }
        return this.dtmfclamp.equals((Object)TRUE);
    }

    public boolean isWebRTC() {
        return this.isValid && this.webrtc.equals((Object)TRUE);
    }
}

