/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.connection;

import java.io.IOException;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.impl.rtp.LocalDataChannel;
import org.mobicents.media.server.mgcp.connection.BaseConnection;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionFailureListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.ModeNotSupportedException;
import org.mobicents.media.server.spi.pooling.PooledObject;
import org.mobicents.media.server.utils.Text;

public class LocalConnectionImpl
extends BaseConnection
implements PooledObject {
    private LocalDataChannel localAudioChannel;

    public LocalConnectionImpl(int id, ChannelsManager channelsManager) {
        super(id, channelsManager.getScheduler());
        this.localAudioChannel = channelsManager.getLocalChannel();
    }

    public void generateCname() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public String getCname() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public AudioComponent getAudioComponent() {
        return this.localAudioChannel.getAudioComponent();
    }

    @Override
    public OOBComponent getOOBComponent() {
        return this.localAudioChannel.getOOBComponent();
    }

    public void generateOffer(boolean webrtc) throws IOException {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    @Override
    public void setOtherParty(Connection other) throws IOException {
        if (!(other instanceof LocalConnectionImpl)) {
            throw new IOException("Not compatible");
        }
        this.localAudioChannel.join(((LocalConnectionImpl)other).localAudioChannel);
        try {
            this.join();
            ((LocalConnectionImpl)other).join();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setOtherParty(Text descriptor) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setOtherParty(byte[] descriptor) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getPacketsReceived() {
        return 0L;
    }

    public long getBytesReceived() {
        return 0L;
    }

    public long getPacketsTransmitted() {
        return 0L;
    }

    public long getBytesTransmitted() {
        return 0L;
    }

    public String toString() {
        return "Local Connection [" + this.getId() + "]";
    }

    public double getJitter() {
        return 0.0;
    }

    @Override
    public void setConnectionFailureListener(ConnectionFailureListener connectionListener) {
    }

    @Override
    protected void onCreated() throws Exception {
    }

    @Override
    protected void onFailed() {
        this.disconnect();
    }

    @Override
    public void setMode(ConnectionMode mode) throws ModeNotSupportedException {
        this.localAudioChannel.updateMode(mode);
        super.setMode(mode);
    }

    @Override
    protected void onOpened() throws Exception {
    }

    @Override
    protected void onClosed() {
        this.disconnect();
    }

    private void disconnect() {
        try {
            this.setMode(ConnectionMode.INACTIVE);
        }
        catch (ModeNotSupportedException modeNotSupportedException) {
            // empty catch block
        }
        this.localAudioChannel.unjoin();
        this.releaseConnection(ConnectionType.LOCAL);
    }

    public boolean isAvailable() {
        return true;
    }

    public void checkIn() {
    }

    public void checkOut() {
    }
}

