/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.mobicents.media.server.mgcp.message.MgcpMessage;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.utils.Text;

public class MgcpRequest
extends MgcpMessage {
    private Text command = new Text();
    private Text endpointID = new Text();
    private int txID;
    private ArrayList<Parameter> parameters = new ArrayList(15);
    private int count;
    private static final byte[] affix = "MGCP 1.0\n".getBytes();
    private boolean sdpDetected = false;
    private Text sdp = new Text();
    private Text msg = new Text();

    public MgcpRequest() {
        for (int i = 0; i < 30; ++i) {
            this.parameters.add(new Parameter());
        }
        this.count = 0;
    }

    public Text getCommand() {
        return this.command;
    }

    public void setCommand(Text command) {
        this.command = command;
    }

    public Text getEndpoint() {
        return this.endpointID;
    }

    public void setEndpoint(Text endpointID) {
        this.endpointID = endpointID;
    }

    @Override
    public int getTxID() {
        return this.txID;
    }

    public void setTxID(int txID) {
        this.txID = txID;
    }

    public Parameter getParameter(Text key) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.parameters.get(i).getKey().equals((Object)key)) continue;
            return this.parameters.get(i);
        }
        return null;
    }

    public void setParameter(Text key, Text value) {
        this.parameters.get(this.count).copy(key, value);
        ++this.count;
    }

    public void strain(byte[] buff, int offset, int len) {
        this.sdpDetected = false;
        this.msg.strain(buff, offset, len);
        Text header = this.msg.nextLine();
        Iterator tokens = header.split(' ').iterator();
        this.command = (Text)tokens.next();
        this.txID = ((Text)tokens.next()).toInteger();
        this.endpointID = (Text)tokens.next();
        this.count = 0;
        while (this.msg.hasMoreLines()) {
            if (this.sdpDetected) {
                this.msg.copyRemainder(this.sdp);
                this.parameters.get(this.count).copy(Parameter.SDP, this.sdp);
                ++this.count;
                return;
            }
            Text line = this.msg.nextLine();
            if (line.length() == 0) {
                this.sdpDetected = true;
                continue;
            }
            int subItemsCount = line.divide(':', this.parameters.get((int)this.count).param);
            if (subItemsCount != 2) continue;
            this.parameters.get(this.count).trim();
            ++this.count;
        }
    }

    @Override
    public void parse(byte[] buff, int offset, int len) {
        this.strain(buff, offset, len);
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.clear();
        buffer.rewind();
        this.command.write(buffer);
        buffer.put((byte)32);
        new Text(this.txID).write(buffer);
        buffer.put((byte)32);
        this.endpointID.write(buffer);
        buffer.put((byte)32);
        buffer.put(affix);
        for (int i = 0; i < this.count; ++i) {
            this.parameters.get(i).write(buffer);
        }
        buffer.flip();
        buffer.rewind();
    }

    @Override
    public void clean() {
        this.count = 0;
        this.sdpDetected = false;
    }

    public String toString() {
        return this.command.toString() + " " + this.endpointID;
    }
}

