/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.au;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.au.BufferListener;
import org.mobicents.media.server.mgcp.pkg.au.EventBuffer;
import org.mobicents.media.server.mgcp.pkg.au.Options;
import org.mobicents.media.server.mgcp.pkg.au.PlayerMode;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.dtmf.DtmfDetector;
import org.mobicents.media.server.spi.dtmf.DtmfDetectorListener;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.spi.recorder.Recorder;
import org.mobicents.media.server.spi.recorder.RecorderEvent;
import org.mobicents.media.server.spi.recorder.RecorderListener;
import org.mobicents.media.server.utils.Text;

public class PlayRecord
extends Signal {
    private static final Logger logger = Logger.getLogger(PlayRecord.class);
    private static final Text RC_300 = new Text("rc=300");
    private static final Text RC_301 = new Text("rc=301");
    private final Event oc = new Event(new Text("oc"));
    private final Event of = new Event(new Text("of"));
    private volatile boolean isActive;
    private Player player;
    private Recorder recorder;
    private DtmfDetector dtmfDetector;
    private Options options;
    private EventBuffer buffer = new EventBuffer();
    private RecordingHandler recordingHandler;
    private DtmfHandler dtmfHandler;
    private PromptHandler promptHandler;
    private volatile boolean isPromptActive;
    private Text[] prompt = new Text[10];
    private Text[] deletePersistentAudio = new Text[100];
    private int promptLength = 0;
    private int promptIndex = 0;
    private int deletePersistentAudioLength = 0;
    private int numberOfAttempts = 1;
    private boolean isCompleted;
    private int segCount = 0;
    private PlayerMode playerMode = PlayerMode.PROMPT;
    private Text eventContent;
    private Boolean playerListenerAdded = false;
    private final Object LOCK = new Object();

    public PlayRecord(String name) {
        super(name);
        this.oc.add(new NotifyImmediately("N"));
        this.of.add(new NotifyImmediately("N"));
        this.recordingHandler = new RecordingHandler(this);
        this.dtmfHandler = new DtmfHandler(this);
        this.promptHandler = new PromptHandler(this);
    }

    @Override
    public void execute() {
        if (this.getEndpoint().getActiveConnectionsCount() == 0) {
            this.oc.fire(this, new Text("rc=327"));
            this.complete();
            return;
        }
        this.promptLength = 0;
        this.promptIndex = 0;
        this.segCount = 0;
        this.isCompleted = false;
        this.isActive = true;
        this.options = Options.allocate(this.getTrigger().getParams());
        if (this.options.hasDeletePresistentAudio()) {
            File f;
            int i;
            this.deletePersistentAudioLength = this.options.getDeletePersistentAudio().size();
            this.deletePersistentAudio = this.options.getDeletePersistentAudio().toArray(this.deletePersistentAudio);
            for (i = 0; i < this.deletePersistentAudioLength; ++i) {
                try {
                    f = new File(this.deletePersistentAudio[i].toString());
                    if (f.exists()) continue;
                    this.oc.fire(this, new Text("rc=320 ri=" + this.deletePersistentAudio[i].toString()));
                    this.isCompleted = true;
                    this.complete();
                    return;
                }
                catch (Exception ex) {
                    logger.error((Object)"OPERATION FAILURE", (Throwable)ex);
                }
            }
            for (i = 0; i < this.deletePersistentAudioLength; ++i) {
                f = new File(this.deletePersistentAudio[i].toString());
                f.delete();
            }
            this.oc.fire(this, new Text("rc=100"));
            this.isCompleted = true;
            this.complete();
            return;
        }
        this.playerMode = PlayerMode.PROMPT;
        this.numberOfAttempts = this.options.getNumberOfAttempts() > 1 ? this.options.getNumberOfAttempts() : 1;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("(%s) Prepare digit collect phase", this.getEndpoint().getLocalName()));
        }
        this.prepareCollectPhase(this.options);
        if (this.options.hasPrompt()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Start prompt phase", this.getEndpoint().getLocalName()));
            }
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("(%s) Start collect phase", this.getEndpoint().getLocalName()));
        }
        this.flushBuffer();
        this.startCollectPhase();
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("(%s) Start record phase", this.getEndpoint().getLocalName()));
        }
        this.startRecordPhase(this.options);
    }

    @Override
    public boolean doAccept(Text event) {
        if (!this.oc.isActive() && this.oc.matches(event)) {
            return true;
        }
        return !this.of.isActive() && this.of.matches(event);
    }

    @Override
    public void cancel() {
        this.isActive = false;
        this.terminate();
    }

    private void startPromptPhase(Collection<Text> promptList) {
        this.player = this.getPlayer();
        try {
            if (!this.playerListenerAdded.booleanValue()) {
                this.player.addListener((PlayerListener)this.promptHandler);
                this.playerListenerAdded = true;
            }
            this.promptLength = promptList.size();
            this.prompt = promptList.toArray(this.prompt);
            this.player.setURL(this.prompt[0].toString());
            this.player.activate();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, RC_300);
            logger.error((Object)"Too many listeners, firing of");
        }
        catch (MalformedURLException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL in invalid format, firing of");
        }
        catch (ResourceUnavailableException e) {
            this.of.fire(this, RC_301);
            logger.info((Object)"Received URL can not be found, firing of");
        }
    }

    private void terminatePrompt() {
        if (this.promptLength > 0) {
            this.promptIndex = this.promptLength - 1;
        }
        if (this.player != null) {
            this.player.deactivate();
            this.player.removeListener((PlayerListener)this.promptHandler);
            this.playerListenerAdded = false;
            this.player = null;
        }
    }

    private void startRecordPhase(Options options) {
        this.recorder = this.getRecorder();
        this.recorder.setMaxRecordTime(options.getRecordDuration());
        this.recorder.setPostSpeechTimer(options.getPostSpeechTimer());
        if (options.getPreSpeechTimer() > 0L) {
            this.recorder.setPreSpeechTimer(options.getPreSpeechTimer());
        } else {
            this.recorder.setPreSpeechTimer(options.getPostSpeechTimer());
        }
        try {
            this.recorder.addListener((RecorderListener)this.recordingHandler);
            this.recorder.setRecordFile(options.getRecordID().toString(), !options.isOverride());
            this.recorder.activate();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, RC_300);
            logger.error((Object)"Too many listeners, firing of");
        }
        catch (IOException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received Recording URL can not be found, firing of 301", (Throwable)e);
        }
    }

    private void terminateRecordPhase() {
        if (this.recorder != null) {
            this.recorder.deactivate();
            this.recorder.removeListener((RecorderListener)this.recordingHandler);
            this.recorder = null;
        }
    }

    private void prepareCollectPhase(Options options) {
        this.dtmfDetector = this.getDetector();
        if (options.isClearDigits()) {
            this.dtmfDetector.clearDigits();
        }
        this.buffer.reset();
        this.buffer.setListener(this.dtmfHandler);
        this.buffer.setPatterns(options.getDigitPattern());
        this.buffer.setCount(options.getDigitsNumber());
    }

    private void terminateCollectPhase() {
        if (this.dtmfDetector != null) {
            this.dtmfDetector.removeListener((DtmfDetectorListener)this.buffer);
            this.buffer.passivate();
            this.buffer.clear();
            this.dtmfDetector = null;
        }
    }

    private void flushBuffer() {
        try {
            this.dtmfDetector.addListener((DtmfDetectorListener)this.buffer);
            this.dtmfDetector.flushBuffer();
        }
        catch (TooManyListenersException e) {
            this.of.fire(this, RC_300);
            logger.error((Object)"Too many listeners, firing of");
        }
    }

    private void startCollectPhase() {
        this.buffer.activate();
        this.buffer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.isPromptActive = false;
            this.terminatePrompt();
            this.terminateRecordPhase();
            this.terminateCollectPhase();
            if (this.options != null) {
                Options.recycle(this.options);
                this.options = null;
            }
        }
    }

    private void decreaseNa() {
        --this.numberOfAttempts;
        if (this.options.hasReprompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getReprompt());
        } else if (this.options.hasPrompt()) {
            this.buffer.passivate();
            this.isPromptActive = true;
            this.startPromptPhase(this.options.getPrompt());
        } else {
            this.startCollectPhase();
        }
    }

    private Player getPlayer() {
        return (Player)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.PLAYER);
    }

    private DtmfDetector getDetector() {
        return (DtmfDetector)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.DTMF_DETECTOR);
    }

    private Recorder getRecorder() {
        return (Recorder)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.RECORDER);
    }

    @Override
    public void reset() {
        super.reset();
        this.terminate();
        this.oc.reset();
        this.of.reset();
    }

    private void next(long delay) {
        ++this.segCount;
        ++this.promptIndex;
        try {
            String url = this.prompt[this.promptIndex].toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Processing player next with url - %s", this.getEndpoint().getLocalName(), url));
            }
            this.player.setURL(url);
            this.player.setInitialDelay(delay);
            this.player.start();
        }
        catch (MalformedURLException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL in invalid format, firing of");
        }
        catch (ResourceUnavailableException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL can not be found, firing of");
        }
    }

    private void prev(long delay) {
        ++this.segCount;
        --this.promptIndex;
        try {
            String url = this.prompt[this.promptIndex].toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Processing player prev with url - %s", this.getEndpoint().getLocalName(), url));
            }
            this.player.setURL(url);
            this.player.setInitialDelay(delay);
            this.player.start();
        }
        catch (MalformedURLException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL in invalid format, firing of");
        }
        catch (ResourceUnavailableException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL can not be found, firing of");
        }
    }

    private void curr(long delay) {
        ++this.segCount;
        try {
            String url = this.prompt[this.promptIndex].toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Processing player curr with url - %s", this.getEndpoint().getLocalName(), url));
            }
            this.player.setURL(url);
            this.player.setInitialDelay(delay);
            this.player.start();
        }
        catch (MalformedURLException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL in invalid format, firing of");
        }
        catch (ResourceUnavailableException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL can not be found, firing of");
        }
    }

    private void first(long delay) {
        ++this.segCount;
        this.promptIndex = 0;
        try {
            String url = this.prompt[this.promptIndex].toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Processing player first with url - %s", this.getEndpoint().getLocalName(), url));
            }
            this.player.setURL(url);
            this.player.setInitialDelay(delay);
            this.player.start();
        }
        catch (MalformedURLException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL in invalid format, firing of");
        }
        catch (ResourceUnavailableException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL can not be found, firing of");
        }
    }

    private void last(long delay) {
        ++this.segCount;
        this.promptIndex = this.promptLength - 1;
        try {
            String url = this.prompt[this.promptIndex].toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Processing player last with url - %s", this.getEndpoint().getLocalName(), url));
            }
            this.player.setURL(url);
            this.player.setInitialDelay(delay);
            this.player.start();
        }
        catch (MalformedURLException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL in invalid format, firing of");
        }
        catch (ResourceUnavailableException e) {
            this.of.fire(this, RC_301);
            logger.error((Object)"Received URL can not be found, firing of");
        }
    }

    private class DtmfHandler
    implements BufferListener {
        private PlayRecord signal;

        public DtmfHandler(PlayRecord signal) {
            this.signal = signal;
        }

        @Override
        public void patternMatches(int index, String s) {
            if (PlayRecord.this.options.hasSuccessAnnouncement()) {
                PlayRecord.this.eventContent = new Text("rc=100 dc=" + s + " pi=" + index);
                PlayRecord.this.playerMode = PlayerMode.SUCCESS;
                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getSuccessAnnouncement());
            } else {
                PlayRecord.this.oc.fire(this.signal, new Text("rc=100 dc=" + s + " pi=" + index));
                PlayRecord.this.reset();
                PlayRecord.this.isCompleted = true;
                PlayRecord.this.complete();
            }
        }

        @Override
        public void countMatches(String s) {
            if (PlayRecord.this.options.hasSuccessAnnouncement()) {
                PlayRecord.this.eventContent = new Text("rc=100 dc=" + s);
                PlayRecord.this.playerMode = PlayerMode.SUCCESS;
                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getSuccessAnnouncement());
            } else {
                PlayRecord.this.oc.fire(this.signal, new Text("rc=100 dc=" + s));
                PlayRecord.this.reset();
                PlayRecord.this.isCompleted = true;
                PlayRecord.this.complete();
            }
        }

        @Override
        public boolean tone(String s) {
            if (PlayRecord.this.options.getDigitsNumber() > 0 && s.charAt(0) == PlayRecord.this.options.getEndInputKey() && PlayRecord.this.buffer.length() >= PlayRecord.this.options.getDigitsNumber()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) End Input Tone '%s' has been detected", PlayRecord.this.getEndpoint().getLocalName(), s));
                }
                if (PlayRecord.this.options.hasSuccessAnnouncement()) {
                    if (PlayRecord.this.options.isIncludeEndInputKey()) {
                        PlayRecord.this.eventContent = new Text("rc=100 dc=" + PlayRecord.this.buffer.getSequence() + s);
                    } else {
                        PlayRecord.this.eventContent = new Text("rc=100 dc=" + PlayRecord.this.buffer.getSequence());
                    }
                    PlayRecord.this.playerMode = PlayerMode.SUCCESS;
                    PlayRecord.this.startPromptPhase(PlayRecord.this.options.getSuccessAnnouncement());
                } else {
                    if (PlayRecord.this.options.isIncludeEndInputKey()) {
                        PlayRecord.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayRecord.this.buffer.getSequence() + s));
                    } else {
                        PlayRecord.this.oc.fire(this.signal, new Text("rc=100 dc=" + PlayRecord.this.buffer.getSequence()));
                    }
                    PlayRecord.this.reset();
                    PlayRecord.this.isCompleted = true;
                    PlayRecord.this.complete();
                }
                return true;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected", PlayRecord.this.getEndpoint().getLocalName(), s));
            }
            if (PlayRecord.this.isPromptActive) {
                if (PlayRecord.this.options.prevKeyValid() && PlayRecord.this.options.getPrevKey() == s.charAt(0)) {
                    PlayRecord.this.prev(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.firstKeyValid() && PlayRecord.this.options.getFirstKey() == s.charAt(0)) {
                    PlayRecord.this.first(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.currKeyValid() && PlayRecord.this.options.getCurrKey() == s.charAt(0)) {
                    PlayRecord.this.curr(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.nextKeyValid() && PlayRecord.this.options.getNextKey() == s.charAt(0)) {
                    PlayRecord.this.next(PlayRecord.this.options.getInterval());
                    return false;
                }
                if (PlayRecord.this.options.lastKeyValid() && PlayRecord.this.options.getLastKey() == s.charAt(0)) {
                    PlayRecord.this.last(PlayRecord.this.options.getInterval());
                    return false;
                }
            }
            if (!PlayRecord.this.options.isNonInterruptable()) {
                if (PlayRecord.this.isPromptActive) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)String.format("(%s) Tone '%s' has been detected: prompt phase interrupted", PlayRecord.this.getEndpoint().getLocalName(), s));
                    }
                    PlayRecord.this.terminatePrompt();
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Tone '%s' has been detected: collected", PlayRecord.this.getEndpoint().getLocalName(), s));
                }
            } else if (PlayRecord.this.isPromptActive) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("(%s) Tone '%s' has been detected, waiting for prompt phase termination", PlayRecord.this.getEndpoint().getLocalName(), s));
                }
                if (PlayRecord.this.options.isClearDigits()) {
                    return false;
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("(%s) Tone '%s' has been detected: collected", PlayRecord.this.getEndpoint().getLocalName(), s));
            }
            return true;
        }
    }

    private class RecordingHandler
    implements RecorderListener {
        private PlayRecord signal;

        protected RecordingHandler(PlayRecord signal) {
            this.signal = signal;
        }

        public void process(RecorderEvent event) {
            block0 : switch (event.getID()) {
                case 2: {
                    switch (event.getQualifier()) {
                        case 1: {
                            if (PlayRecord.this.numberOfAttempts == 1) {
                                PlayRecord.this.oc.fire(this.signal, new Text("rc=328"));
                                break block0;
                            }
                            if (PlayRecord.this.options.hasFailureAnnouncement()) {
                                PlayRecord.this.eventContent = new Text("rc=328");
                                PlayRecord.this.playerMode = PlayerMode.FAILURE;
                                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getFailureAnnouncement());
                                break block0;
                            }
                            PlayRecord.this.oc.fire(this.signal, new Text("rc=328"));
                            break block0;
                        }
                        case 2: {
                            if (PlayRecord.this.numberOfAttempts == 1) {
                                PlayRecord.this.oc.fire(this.signal, new Text("rc=327"));
                                break block0;
                            }
                            if (PlayRecord.this.options.hasNoSpeechReprompt()) {
                                PlayRecord.this.eventContent = new Text("rc=327");
                                PlayRecord.this.playerMode = PlayerMode.FAILURE;
                                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getNoSpeechReprompt());
                                break block0;
                            }
                            if (PlayRecord.this.options.hasFailureAnnouncement()) {
                                PlayRecord.this.eventContent = new Text("rc=327");
                                PlayRecord.this.playerMode = PlayerMode.FAILURE;
                                PlayRecord.this.startPromptPhase(PlayRecord.this.options.getFailureAnnouncement());
                                break block0;
                            }
                            PlayRecord.this.oc.fire(this.signal, new Text("rc=327"));
                        }
                    }
                }
            }
        }
    }

    private class PromptHandler
    implements PlayerListener {
        private PlayRecord signal;

        protected PromptHandler(PlayRecord signal) {
            this.signal = signal;
        }

        public void process(PlayerEvent event) {
            switch (event.getID()) {
                case 1: {
                    if (PlayRecord.this.segCount != 0) break;
                    PlayRecord.this.flushBuffer();
                    break;
                }
                case 2: {
                    if (PlayRecord.this.promptIndex < PlayRecord.this.promptLength - 1) {
                        PlayRecord.this.next(PlayRecord.this.options.getInterval());
                        return;
                    }
                    switch (PlayRecord.this.playerMode) {
                        case PROMPT: {
                            if (!PlayRecord.this.isPromptActive) break;
                            PlayRecord.this.isPromptActive = false;
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)String.format("(%s) Prompt phase terminated, start collect/record phase", PlayRecord.this.getEndpoint().getLocalName()));
                            }
                            PlayRecord.this.startCollectPhase();
                            if (PlayRecord.this.isCompleted) break;
                            PlayRecord.this.startRecordPhase(PlayRecord.this.options);
                            break;
                        }
                        case SUCCESS: {
                            PlayRecord.this.oc.fire(this.signal, PlayRecord.this.eventContent);
                            PlayRecord.this.reset();
                            PlayRecord.this.isCompleted = true;
                            PlayRecord.this.complete();
                            break;
                        }
                        case FAILURE: {
                            if (PlayRecord.this.numberOfAttempts == 1) {
                                PlayRecord.this.oc.fire(this.signal, PlayRecord.this.eventContent);
                                PlayRecord.this.reset();
                                PlayRecord.this.isCompleted = true;
                                PlayRecord.this.complete();
                                break;
                            }
                            PlayRecord.this.decreaseNa();
                        }
                    }
                    break;
                }
                case 3: {
                    PlayRecord.this.of.fire(this.signal, null);
                    PlayRecord.this.complete();
                }
            }
        }
    }
}

