/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.io.network.channel.Channel;
import org.mobicents.media.server.io.network.channel.MultiplexedChannel;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.MgcpListener;
import org.mobicents.media.server.mgcp.message.MgcpMessage;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.MgcpResponse;
import org.mobicents.media.server.spi.listener.Event;
import org.mobicents.media.server.spi.listener.Listener;
import org.mobicents.media.server.spi.listener.Listeners;
import org.mobicents.media.server.spi.listener.TooManyListenersException;

public class MgcpProvider
extends MultiplexedChannel {
    private static final Logger log = Logger.getLogger(MgcpProvider.class);
    private final UdpManager transport;
    private final MGCPHandler mgcpHandler;
    private final int port;
    private final ConcurrentLinkedQueue<ByteBuffer> txBuffer = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<MgcpEventImpl> events = new ConcurrentLinkedQueue();
    private final Listeners<MgcpListener> listeners = new Listeners();

    public MgcpProvider(UdpManager transport, int port) {
        int i;
        this.transport = transport;
        this.mgcpHandler = new MGCPHandler();
        this.port = port;
        this.handlers.addHandler((PacketHandler)this.mgcpHandler);
        for (i = 0; i < 100; ++i) {
            this.events.offer(new MgcpEventImpl(this));
        }
        for (i = 0; i < 100; ++i) {
            this.txBuffer.offer(ByteBuffer.allocate(8192));
        }
    }

    public MgcpEvent createEvent(int eventID, SocketAddress address) {
        MgcpEventImpl evt = this.events.poll();
        if (evt == null) {
            evt = new MgcpEventImpl(this);
        }
        evt.inQueue.set(false);
        evt.setEventID(eventID);
        evt.setAddress(address);
        return evt;
    }

    public void send(MgcpEvent event) throws IOException {
        MgcpMessage msg = event.getMessage();
        ByteBuffer currBuffer = this.txBuffer.poll();
        if (currBuffer == null) {
            currBuffer = ByteBuffer.allocate(8192);
        }
        msg.write(currBuffer);
        this.dataChannel.send(currBuffer, event.getAddress());
        currBuffer.clear();
        this.txBuffer.offer(currBuffer);
    }

    public void addListener(MgcpListener listener) throws TooManyListenersException {
        this.listeners.add((Listener)listener);
    }

    public void removeListener(MgcpListener listener) {
        this.listeners.remove((Listener)listener);
    }

    public void activate() {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"Opening MGCP channel");
            }
            this.selectionKey = this.transport.open((Channel)this);
            this.dataChannel = (DatagramChannel)this.selectionKey.channel();
        }
        catch (Exception e) {
            log.error((Object)"Could not open MGCP channel", (Throwable)e);
            return;
        }
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Binding channel to " + this.transport.getLocalBindAddress() + ":" + this.port));
            }
            this.transport.bindLocal(this.dataChannel, this.port);
        }
        catch (Exception e) {
            log.error((Object)"Could not bind MGCP channel. Closing the channel.", (Throwable)e);
            this.close();
        }
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Closing the MGCP channel.");
        }
        this.close();
    }

    private void recycleEvent(MgcpEventImpl event) {
        if (event.inQueue.getAndSet(true)) {
            log.warn((Object)"====================== ALARM ALARM ALARM==============");
        } else {
            event.response.clean();
            event.request.clean();
            this.events.offer(event);
        }
    }

    private class MgcpEventImpl
    implements MgcpEvent {
        private MgcpProvider provider;
        private int eventID;
        private MgcpRequest request = new MgcpRequest();
        private MgcpResponse response = new MgcpResponse();
        private SocketAddress address;
        private AtomicBoolean inQueue = new AtomicBoolean(true);

        public MgcpEventImpl(MgcpProvider provider) {
            this.provider = provider;
        }

        public MgcpProvider getSource() {
            return this.provider;
        }

        @Override
        public MgcpMessage getMessage() {
            return this.eventID == 1 ? this.request : this.response;
        }

        @Override
        public int getEventID() {
            return this.eventID;
        }

        protected void setEventID(int eventID) {
            this.eventID = eventID;
        }

        @Override
        public void recycle() {
            MgcpProvider.this.recycleEvent(this);
        }

        @Override
        public SocketAddress getAddress() {
            return this.address;
        }

        protected void setAddress(SocketAddress address) {
            InetSocketAddress a = (InetSocketAddress)address;
            this.address = new InetSocketAddress(a.getAddress().getHostAddress(), a.getPort());
        }
    }

    private class MGCPHandler
    implements PacketHandler {
        private MGCPHandler() {
        }

        public int compareTo(PacketHandler o) {
            if (o == null) {
                return 1;
            }
            return this.getPipelinePriority() - o.getPipelinePriority();
        }

        public boolean canHandle(byte[] packet) {
            return this.canHandle(packet, packet.length, 0);
        }

        public boolean canHandle(byte[] packet, int dataLength, int offset) {
            return true;
        }

        public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
            return this.handle(packet, packet.length, 0, localPeer, remotePeer);
        }

        public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
            try {
                byte b = packet[0];
                int msgType = b >= 48 && b <= 57 ? 2 : 1;
                MgcpEvent evt = MgcpProvider.this.createEvent(msgType, remotePeer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing message: " + new String(packet, offset, dataLength)));
                }
                evt.getMessage().parse(packet, offset, dataLength);
                MgcpProvider.this.listeners.dispatch((Event)evt);
            }
            catch (Exception e) {
                throw new PacketHandlerException((Throwable)e);
            }
            return null;
        }

        public int getPipelinePriority() {
            return 0;
        }
    }
}

