/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.endpoint;

import java.util.concurrent.atomic.AtomicInteger;
import org.mobicents.media.server.component.audio.AudioSplitter;
import org.mobicents.media.server.component.oob.OOBSplitter;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.io.ss7.SS7DataChannel;
import org.mobicents.media.server.mgcp.connection.BaseConnection;
import org.mobicents.media.server.mgcp.endpoint.BaseEndpointImpl;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.dsp.DspFactory;

public class BaseSS7EndpointImpl
extends BaseEndpointImpl {
    protected AudioSplitter audioSplitter;
    protected OOBSplitter oobSplitter;
    private AtomicInteger loopbackCount = new AtomicInteger(0);
    private AtomicInteger readCount = new AtomicInteger(0);
    private AtomicInteger writeCount = new AtomicInteger(0);
    private SS7DataChannel ss7DataChannel;
    private int channelID;
    private boolean isALaw;
    private ChannelsManager channelsManager;
    private DspFactory dsp;

    public BaseSS7EndpointImpl(String localName, ChannelsManager channelsManager, int channelID, boolean isALaw, DspFactory dsp) {
        super(localName);
        this.isALaw = isALaw;
        this.channelID = channelID;
        this.channelsManager = channelsManager;
        this.dsp = dsp;
    }

    @Override
    public void start() throws ResourceUnavailableException {
        super.start();
        this.audioSplitter = new AudioSplitter(this.getScheduler());
        this.oobSplitter = new OOBSplitter(this.getScheduler());
        this.audioSplitter.addOutsideComponent(this.mediaGroup.getAudioComponent());
        this.oobSplitter.addOutsideComponent(this.mediaGroup.getOOBComponent());
        try {
            this.ss7DataChannel = this.channelsManager.getSS7Channel(this.channelID, this.isALaw);
        }
        catch (Exception ex) {
            throw new ResourceUnavailableException("Can not open dahdi channel");
        }
        try {
            this.ss7DataChannel.setInputDsp(this.dsp.newProcessor());
            this.ss7DataChannel.setOutputDsp(this.dsp.newProcessor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.audioSplitter.addInsideComponent(this.ss7DataChannel.getAudioComponent());
        this.oobSplitter.addInsideComponent(this.ss7DataChannel.getOOBComponent());
    }

    @Override
    public void stop() {
        this.audioSplitter.releaseInsideComponent(this.ss7DataChannel.getAudioComponent());
        this.oobSplitter.releaseInsideComponent(this.ss7DataChannel.getOOBComponent());
        this.audioSplitter.releaseOutsideComponent(this.mediaGroup.getAudioComponent());
        this.oobSplitter.releaseOutsideComponent(this.mediaGroup.getOOBComponent());
        super.stop();
    }

    @Override
    public Connection createConnection(ConnectionType type, Boolean isLocal) throws ResourceUnavailableException {
        Connection connection = super.createConnection(type, isLocal);
        this.audioSplitter.addOutsideComponent(((BaseConnection)connection).getAudioComponent());
        this.oobSplitter.addOutsideComponent(((BaseConnection)connection).getOOBComponent());
        if (this.getActiveConnectionsCount() == 1) {
            this.ss7DataChannel.bind();
            this.readCount.set(1);
            this.writeCount.set(1);
        }
        return connection;
    }

    @Override
    public void deleteConnection(Connection connection, ConnectionType connectionType) {
        super.deleteConnection(connection, connectionType);
        this.audioSplitter.releaseOutsideComponent(((BaseConnection)connection).getAudioComponent());
        this.oobSplitter.releaseOutsideComponent(((BaseConnection)connection).getOOBComponent());
        if (this.getActiveConnectionsCount() == 0) {
            this.ss7DataChannel.close();
            this.readCount.set(0);
            this.writeCount.set(0);
        }
    }

    public void modeUpdated(ConnectionMode oldMode, ConnectionMode newMode) {
        int readCount = 0;
        int loopbackCount = 0;
        int writeCount = 0;
        switch (oldMode) {
            case RECV_ONLY: {
                readCount = -1;
                break;
            }
            case SEND_ONLY: {
                writeCount = -1;
                break;
            }
            case SEND_RECV: 
            case CONFERENCE: {
                readCount = -1;
                writeCount = -1;
                break;
            }
            case NETWORK_LOOPBACK: {
                loopbackCount = -1;
                break;
            }
        }
        switch (newMode) {
            case RECV_ONLY: {
                readCount = 1;
                break;
            }
            case SEND_ONLY: {
                writeCount = 1;
                break;
            }
            case SEND_RECV: 
            case CONFERENCE: {
                readCount = 1;
                writeCount = 1;
                break;
            }
            case NETWORK_LOOPBACK: {
                loopbackCount = 1;
                break;
            }
        }
        if (readCount != 0 || writeCount != 0 || loopbackCount != 0) {
            loopbackCount = this.loopbackCount.addAndGet(loopbackCount);
            readCount = this.readCount.addAndGet(readCount);
            writeCount = this.writeCount.addAndGet(writeCount);
            if (loopbackCount > 0 || readCount == 0 || writeCount == 0) {
                this.audioSplitter.stop();
                this.oobSplitter.stop();
            } else {
                this.audioSplitter.start();
                this.oobSplitter.start();
            }
        }
    }

    public void setLoop(boolean toSet) {
        Boolean oldState = this.ss7DataChannel.inLoop();
        if (toSet && !oldState.booleanValue()) {
            this.ss7DataChannel.activateLoop();
            this.loopbackCount.addAndGet(1);
            this.audioSplitter.stop();
            this.oobSplitter.stop();
        } else if (!toSet && oldState.booleanValue()) {
            this.ss7DataChannel.deactivateLoop();
            this.loopbackCount.addAndGet(-1);
            if (this.loopbackCount.get() == 0 && this.readCount.get() > 0 && this.writeCount.get() > 0) {
                this.audioSplitter.start();
                this.oobSplitter.start();
            }
        }
    }

    public void configure(boolean isALaw) {
        this.ss7DataChannel.setCodec(isALaw);
    }
}

