/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.ann;

import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.listener.TooManyListenersException;
import org.mobicents.media.server.spi.player.Player;
import org.mobicents.media.server.spi.player.PlayerEvent;
import org.mobicents.media.server.spi.player.PlayerListener;
import org.mobicents.media.server.utils.Text;

public class Play
extends Signal
implements PlayerListener {
    private Text oc = new Text("oc");
    private Text of = new Text("of");
    private Player player;
    private String uri;
    private static final Logger logger = Logger.getLogger(Play.class);

    public Play(String name) {
        super(name);
    }

    @Override
    public void execute() {
        logger.info((Object)"Executing...");
        this.player = this.getPlayer();
        try {
            this.player.addListener((PlayerListener)this);
            this.uri = this.getTrigger().getParams().toString();
            this.player.setURL(this.uri);
            logger.info((Object)("Assigned url " + this.player));
        }
        catch (TooManyListenersException e) {
            this.sendEvent(this.of);
            this.complete();
            logger.error((Object)"OPERATION FAILURE", (Throwable)e);
            return;
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Received URL in invalid format , firing of");
            this.sendEvent(this.of);
            this.complete();
            return;
        }
        catch (ResourceUnavailableException e) {
            logger.info((Object)"Received URL can not be found , firing of");
            this.sendEvent(this.of);
            this.complete();
            return;
        }
        this.player.activate();
    }

    @Override
    public boolean doAccept(Text event) {
        if (event.equals((Object)this.oc)) {
            return true;
        }
        return event.equals((Object)this.of);
    }

    @Override
    public void cancel() {
        this.terminate();
    }

    private Player getPlayer() {
        return (Player)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.PLAYER);
    }

    private void terminate() {
        if (this.player != null) {
            this.player.removeListener((PlayerListener)this);
            this.player.deactivate();
            this.player = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.terminate();
    }

    public void process(PlayerEvent event) {
        switch (event.getID()) {
            case 2: {
                this.terminate();
                this.sendEvent(this.oc);
                this.complete();
                break;
            }
            case 3: {
                this.terminate();
                this.sendEvent(this.of);
                this.complete();
            }
        }
    }
}

