/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp;

import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.MgcpProvider;

public class MgcpPacketHandler
implements PacketHandler {
    private static final Logger log = Logger.getLogger(MgcpPacketHandler.class);
    private final MgcpProvider provider;

    public MgcpPacketHandler(MgcpProvider provider) {
        this.provider = provider;
    }

    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return this.getPipelinePriority() - o.getPipelinePriority();
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        return true;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        try {
            byte b = packet[0];
            int msgType = b >= 48 && b <= 57 ? 2 : 1;
            MgcpEvent evt = this.provider.createEvent(msgType, remotePeer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing message: " + new String(packet, offset, dataLength)));
            }
            evt.getMessage().parse(packet, offset, dataLength);
            this.provider.onIncomingEvent(evt);
        }
        catch (Exception e) {
            throw new PacketHandlerException((Throwable)e);
        }
        return null;
    }

    public int getPipelinePriority() {
        return 0;
    }
}

