/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller.signal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.mobicents.media.server.mgcp.controller.Request;
import org.mobicents.media.server.mgcp.controller.UnknownActivityException;
import org.mobicents.media.server.mgcp.controller.UnknownEventException;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.utils.Text;

public class MgcpPackage {
    private Text name;
    private ArrayList<Signal> signals = new ArrayList();
    protected Request request;

    public MgcpPackage(String name, Collection<Signal> signals) {
        this.name = new Text(name);
        this.setPackage(signals);
    }

    private void setPackage(Collection<Signal> signals) {
        for (Signal s : signals) {
            s.setPackage(this);
            this.signals.add(s);
        }
    }

    public Text getName() {
        return this.name;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void accept(Text event) throws UnknownEventException {
        boolean accepted = false;
        for (Signal signal : this.signals) {
            accepted |= signal.accept(event);
        }
        if (!accepted) {
            throw new UnknownEventException(event.toString());
        }
    }

    public void reset() {
        for (Signal signal : this.signals) {
            signal.reset();
        }
    }

    private Signal loadSignal(String eventName, Properties config) throws Exception {
        Constructor<?>[] constructors;
        if (!config.containsKey(eventName)) {
            throw new IllegalArgumentException("Event/signal " + eventName + " is not implemented");
        }
        String className = config.getProperty(eventName);
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> def = loader.loadClass(className);
        Constructor<?> constructor = null;
        for (Constructor<?> cons : constructors = def.getConstructors()) {
            Class<?>[] paramTypes = cons.getParameterTypes();
            if (paramTypes.length != 1 || paramTypes[0] != String.class) continue;
            constructor = cons;
            break;
        }
        if (constructor == null) {
            throw new InstantiationException("Signal must have constructor with string name");
        }
        Signal s = (Signal)constructor.newInstance(eventName);
        return s;
    }

    public void onEvent(Text event) {
        this.request.onEvent(event);
    }

    public void completed() {
        this.request.completed();
    }

    public Endpoint getEndpoint() {
        return this.request.getEndpoint();
    }

    public Connection getConnection(String ID) throws UnknownActivityException {
        return this.request.getConnection(ID);
    }

    public Signal getSignal(Text name) {
        for (Signal s : this.signals) {
            if (!s.getName().equals((Object)name)) continue;
            return s;
        }
        return null;
    }
}

