/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.endpoint.naming;

import java.util.ArrayList;

public class EndpointNameGenerator {
    private ArrayList<Term> terms = new ArrayList();

    public void setPattern(String pattern) {
        String[] parts;
        for (String part : parts = pattern.split("/")) {
            Term term;
            if ((part = part.trim()).length() == 0) continue;
            Term term2 = term = part.startsWith("[") ? new NumericRange(part) : new Term(part);
            if (this.terms.size() > 0) {
                this.terms.get(this.terms.size() - 1).setChild(term);
            }
            this.terms.add(term);
        }
    }

    public boolean hasMore() {
        return this.terms.size() > 0 && this.terms.get(0).hasMore();
    }

    public String next() {
        return this.terms.get(0).next();
    }

    private class NumericRange
    extends Term {
        private int low;
        private int high;
        private int value;

        public NumericRange(String term) {
            super(term);
            term = term.substring(1, term.length() - 1);
            term = term.replaceAll("]", "");
            String[] tokens = term.split("\\.\\.");
            this.low = Integer.parseInt(tokens[0]);
            this.high = Integer.parseInt(tokens[1]);
            this.value = this.low;
        }

        @Override
        public void reset() {
            this.term = this.term.substring(1, this.term.length() - 1);
            this.term = this.term.replaceAll("]", "");
            String[] tokens = this.term.split("\\.\\.");
            this.low = Integer.parseInt(tokens[0]);
            this.high = Integer.parseInt(tokens[1]);
            this.value = this.low;
        }

        @Override
        public boolean hasMore() {
            return this.child == null ? this.value <= this.high : this.value < this.high || this.child.hasMore();
        }

        @Override
        public String next() {
            String s;
            if (this.child != null && !this.child.hasMore()) {
                ++this.value;
                this.child.reset();
            }
            String string = s = this.child != null ? Integer.toString(this.value) + "/" + this.child.next() : Integer.toString(this.value);
            if (this.child == null) {
                ++this.value;
            }
            return s;
        }
    }

    private class Term {
        protected String term;
        private boolean hasMore = true;
        protected Term child;

        public Term(String term) {
            this.term = term;
        }

        public void reset() {
            this.hasMore = true;
        }

        public void setChild(Term child) {
            this.child = child;
        }

        public boolean hasMore() {
            return this.child != null ? this.child.hasMore() : this.hasMore;
        }

        public String next() {
            if (this.child == null) {
                this.hasMore = false;
            }
            return this.child != null ? this.term + "/" + this.child.next() : this.term;
        }
    }
}

