/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.connection;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.impl.rtp.CnameGenerator;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.rtp.channels.AudioChannel;
import org.mobicents.media.server.impl.rtp.channels.MediaChannel;
import org.mobicents.media.server.impl.rtp.sdp.SdpFactory;
import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.SessionDescriptionParser;
import org.mobicents.media.server.io.sdp.dtls.attributes.FingerprintAttribute;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpAttribute;
import org.mobicents.media.server.mgcp.connection.BaseConnection;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionFailureListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.ModeNotSupportedException;
import org.mobicents.media.server.spi.dsp.DspFactory;
import org.mobicents.media.server.spi.pooling.PooledObject;
import org.mobicents.media.server.utils.Text;

public class RtpConnectionImpl
extends BaseConnection
implements RtpListener,
PooledObject {
    private static final Logger logger = Logger.getLogger(RtpConnectionImpl.class);
    private final ChannelsManager channelsManager;
    private String cname;
    private boolean outbound;
    private boolean local;
    private AudioChannel audioChannel;
    private SessionDescription localSdp;
    private SessionDescription remoteSdp;
    private ConnectionFailureListener connectionFailureListener;

    public RtpConnectionImpl(int id, ChannelsManager channelsManager, DspFactory dspFactory) {
        super(id, channelsManager.getScheduler());
        this.channelsManager = channelsManager;
        this.outbound = false;
        this.local = false;
        this.cname = CnameGenerator.generateCname();
        this.audioChannel = this.channelsManager.getAudioChannel();
        this.audioChannel.setCname(this.cname);
        try {
            this.audioChannel.setInputDsp(dspFactory.newProcessor());
            this.audioChannel.setOutputDsp(dspFactory.newProcessor());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("There are invalid classes specified in the configuration.", e);
        }
    }

    public void generateCname() {
        this.cname = CnameGenerator.generateCname();
        if (this.audioChannel != null) {
            this.audioChannel.setCname(this.cname);
        }
    }

    public String getCname() {
        return this.cname;
    }

    @Override
    public AudioComponent getAudioComponent() {
        return this.audioChannel.getAudioComponent();
    }

    @Override
    public OOBComponent getOOBComponent() {
        return this.audioChannel.getAudioOobComponent();
    }

    @Override
    public boolean getIsLocal() {
        return this.local;
    }

    @Override
    public void setIsLocal(boolean isLocal) {
        this.local = isLocal;
    }

    @Override
    public void setOtherParty(Connection other) throws IOException {
        throw new IOException("Applicable only for a local connection");
    }

    @Override
    public void setOtherParty(byte[] descriptor) throws IOException {
        try {
            this.remoteSdp = SessionDescriptionParser.parse((String)new String(descriptor));
            if (ConnectionState.OPEN.equals((Object)this.getState())) {
                this.renegotiateSession();
            } else {
                this.setOtherParty();
            }
        }
        catch (SdpException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setOtherParty(Text descriptor) throws IOException {
        this.setOtherParty(descriptor.toString().getBytes());
    }

    private void renegotiateSession() throws IOException {
        MediaDescriptionField remoteApplication;
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        this.audioChannel.negotiateFormats(remoteAudio);
        if (!this.audioChannel.containsNegotiatedFormats()) {
            throw new IOException("Audio codecs were not supported");
        }
        String bindAddress = this.local ? this.channelsManager.getLocalBindAddress() : this.channelsManager.getBindAddress();
        String externalAddress = this.channelsManager.getUdpManager().getExternalAddress();
        this.localSdp = SdpFactory.buildSdp((boolean)false, (String)bindAddress, (String)externalAddress, (MediaChannel[])new MediaChannel[]{this.audioChannel});
        MediaDescriptionField remoteVideo = this.remoteSdp.getMediaDescription("video");
        if (remoteVideo != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteVideo);
        }
        if ((remoteApplication = this.remoteSdp.getMediaDescription("application")) != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteApplication);
        }
        String remoteAddr = remoteAudio.getConnection().getAddress();
        this.audioChannel.connectRtp(remoteAddr, remoteAudio.getPort());
        this.audioChannel.connectRtcp(remoteAddr, remoteAudio.getRtcpPort());
    }

    private void setOtherParty() throws IOException {
        if (this.outbound) {
            this.setOtherPartyOutboundCall();
        } else {
            this.setOtherPartyInboundCall();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Audio formats: " + this.audioChannel.getFormatMap()));
        }
    }

    private void setOtherPartyInboundCall() throws IOException {
        MediaDescriptionField remoteApplication;
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        if (remoteAudio != null) {
            this.audioChannel.open();
            this.setupAudioChannelInbound(remoteAudio);
        }
        String bindAddress = this.local ? this.channelsManager.getLocalBindAddress() : this.channelsManager.getBindAddress();
        String externalAddress = this.channelsManager.getUdpManager().getExternalAddress();
        this.localSdp = this.audioChannel.isOpen() ? SdpFactory.buildSdp((boolean)false, (String)bindAddress, (String)externalAddress, (MediaChannel[])new MediaChannel[]{this.audioChannel}) : SdpFactory.buildSdp((boolean)false, (String)bindAddress, (String)externalAddress, (MediaChannel[])new MediaChannel[0]);
        MediaDescriptionField remoteVideo = this.remoteSdp.getMediaDescription("video");
        if (remoteVideo != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteVideo);
        }
        if ((remoteApplication = this.remoteSdp.getMediaDescription("application")) != null) {
            SdpFactory.rejectMediaField((SessionDescription)this.localSdp, (MediaDescriptionField)remoteApplication);
        }
        try {
            this.join();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not set connection state to OPEN", (Throwable)e);
        }
    }

    private void setOtherPartyOutboundCall() throws IOException {
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        if (remoteAudio != null) {
            if (this.audioChannel.isDtlsEnabled()) {
                FingerprintAttribute fingerprint = remoteAudio.getFingerprint();
                this.audioChannel.setRemoteFingerprint(fingerprint.getHashFunction(), fingerprint.getFingerprint());
            }
            this.setupAudioChannelOutbound(remoteAudio);
        }
        try {
            this.join();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not set connection state to OPEN", (Throwable)e);
        }
    }

    private void setupAudioChannelInbound(MediaDescriptionField remoteAudio) throws IOException {
        this.audioChannel.negotiateFormats(remoteAudio);
        if (!this.audioChannel.containsNegotiatedFormats()) {
            throw new IOException("Audio codecs were not supported");
        }
        this.audioChannel.bind(this.local, remoteAudio.isRtcpMux());
        boolean enableIce = remoteAudio.containsIce();
        if (enableIce) {
            this.audioChannel.enableICE(this.channelsManager.getExternalAddress(), remoteAudio.isRtcpMux());
        } else {
            String remoteAddr = remoteAudio.getConnection().getAddress();
            this.audioChannel.connectRtp(remoteAddr, remoteAudio.getPort());
            this.audioChannel.connectRtcp(remoteAddr, remoteAudio.getRtcpPort());
        }
        boolean enableDtls = this.remoteSdp.containsDtls();
        if (enableDtls) {
            FingerprintAttribute fingerprint = this.remoteSdp.getFingerprint(this.audioChannel.getMediaType());
            this.audioChannel.enableDTLS(fingerprint.getHashFunction(), fingerprint.getFingerprint());
        }
    }

    private void setupAudioChannelOutbound(MediaDescriptionField remoteAudio) throws IOException {
        boolean connectNow;
        this.audioChannel.negotiateFormats(remoteAudio);
        if (!this.audioChannel.containsNegotiatedFormats()) {
            throw new IOException("Audio codecs were not supported");
        }
        String remoteRtpAddress = remoteAudio.getConnection().getAddress();
        int remoteRtpPort = remoteAudio.getPort();
        boolean bl = connectNow = !this.outbound || !this.audioChannel.isIceEnabled();
        if (connectNow) {
            this.audioChannel.connectRtp(remoteRtpAddress, remoteRtpPort);
            boolean remoteRtcpMux = remoteAudio.isRtcpMux();
            if (remoteRtcpMux) {
                this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort);
            } else {
                RtcpAttribute remoteRtcp = remoteAudio.getRtcp();
                if (remoteRtcp == null) {
                    this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort + 1);
                } else {
                    String remoteRtcpAddress = remoteRtcp.getAddress();
                    if (remoteRtcpAddress == null) {
                        remoteRtcpAddress = remoteRtpAddress;
                    }
                    int remoteRtcpPort = remoteRtcp.getPort();
                    this.audioChannel.connectRtcp(remoteRtcpAddress, remoteRtcpPort);
                }
            }
        }
    }

    @Override
    public void setMode(ConnectionMode mode) throws ModeNotSupportedException {
        this.audioChannel.setConnectionMode(mode);
        super.setMode(mode);
    }

    @Override
    public String getDescriptor() {
        return this.localSdp == null ? "" : this.localSdp.toString();
    }

    public void generateOffer(boolean webrtc) throws IOException {
        if (!this.audioChannel.isOpen()) {
            this.outbound = true;
            this.audioChannel.open();
            this.audioChannel.bind(this.local, webrtc);
            if (webrtc) {
                this.audioChannel.enableICE(this.channelsManager.getExternalAddress(), true);
                this.audioChannel.enableDTLS();
            }
            String bindAddress = this.local ? this.channelsManager.getLocalBindAddress() : this.channelsManager.getBindAddress();
            String externalAddress = this.channelsManager.getUdpManager().getExternalAddress();
            this.localSdp = SdpFactory.buildSdp((boolean)true, (String)bindAddress, (String)externalAddress, (MediaChannel[])new MediaChannel[]{this.audioChannel});
            this.remoteSdp = null;
        }
    }

    @Override
    public String getLocalDescriptor() {
        return this.localSdp == null ? "" : this.localSdp.toString();
    }

    @Override
    public String getRemoteDescriptor() {
        return this.remoteSdp == null ? "" : this.remoteSdp.toString();
    }

    public long getPacketsReceived() {
        return this.audioChannel.getPacketsReceived();
    }

    public long getBytesReceived() {
        return this.audioChannel.getOctetsReceived();
    }

    public long getPacketsTransmitted() {
        return this.audioChannel.getPacketsSent();
    }

    public long getBytesTransmitted() {
        return this.audioChannel.getOctetsSent();
    }

    public double getJitter() {
        return this.audioChannel.getJitter();
    }

    public boolean isAvailable() {
        return this.audioChannel.isAvailable();
    }

    public String toString() {
        return "RTP Connection [" + this.getEndpoint().getLocalName() + "]";
    }

    private void closeResources() {
        if (this.audioChannel.isOpen()) {
            this.audioChannel.close();
        }
    }

    private void reset() {
        this.outbound = false;
        this.localSdp = null;
        this.remoteSdp = null;
    }

    public void onRtpFailure(String message) {
        if (this.audioChannel.isOpen()) {
            logger.warn((Object)message);
            this.onFailed();
        }
    }

    public void onRtpFailure(Throwable e) {
        String message = "RTP failure!";
        if (e != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtpFailure(message);
    }

    public void onRtcpFailure(String e) {
        if (this.audioChannel.isOpen()) {
            logger.warn((Object)e);
            this.onFailed();
        }
    }

    public void onRtcpFailure(Throwable e) {
        String message = "RTCP failure!";
        if (e != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtcpFailure(message);
    }

    @Override
    public void setConnectionFailureListener(ConnectionFailureListener connectionFailureListener) {
        this.connectionFailureListener = connectionFailureListener;
    }

    @Override
    protected void onCreated() throws Exception {
        this.reset();
    }

    @Override
    protected void onFailed() {
        this.closeResources();
        if (this.connectionFailureListener != null) {
            this.connectionFailureListener.onFailure();
        }
    }

    @Override
    protected void onOpened() throws Exception {
    }

    @Override
    protected void onClosed() {
        this.closeResources();
        try {
            this.setMode(ConnectionMode.INACTIVE);
        }
        catch (ModeNotSupportedException e) {
            logger.warn((Object)"Could not set connection mode to INACTIVE.", (Throwable)e);
        }
        this.releaseConnection(ConnectionType.RTP);
        this.connectionFailureListener = null;
    }

    public void checkIn() {
        this.closeResources();
        this.reset();
    }

    public void checkOut() {
        this.generateCname();
    }
}

